/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.rest.jersey;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.client.core.Condition;
import org.sonatype.nexus.client.core.NexusClient;
import org.sonatype.nexus.client.core.NexusStatus;
import org.sonatype.nexus.client.core.exception.NexusClientAccessForbiddenException;
import org.sonatype.nexus.client.core.exception.NexusClientBadRequestException;
import org.sonatype.nexus.client.core.exception.NexusClientErrorResponseException;
import org.sonatype.nexus.client.core.exception.NexusClientException;
import org.sonatype.nexus.client.core.exception.NexusClientNotFoundException;
import org.sonatype.nexus.client.core.exception.NexusClientResponseException;
import org.sonatype.nexus.client.core.spi.SubsystemProvider;
import org.sonatype.nexus.client.internal.msg.ErrorMessage;
import org.sonatype.nexus.client.internal.msg.ErrorResponse;
import org.sonatype.nexus.client.internal.rest.AbstractXStreamNexusClient;
import org.sonatype.nexus.client.internal.util.Check;
import org.sonatype.nexus.client.rest.ConnectionInfo;
import org.sonatype.nexus.client.rest.jersey.ContextAwareUniformInterfaceException;
import org.sonatype.nexus.client.rest.jersey.NexusClientHandlerException;
import org.sonatype.nexus.rest.model.StatusResource;
import org.sonatype.nexus.rest.model.StatusResourceResponse;
import org.sonatype.sisu.siesta.client.ClientBuilder;

public class JerseyNexusClient
extends AbstractXStreamNexusClient {
    private Client client;
    private final MediaType mediaType;
    private final List<SubsystemProvider> subsystemProviders;
    private final Map<Object, Object> context;

    public JerseyNexusClient(Condition connectionCondition, List<SubsystemProvider> subsystemProviders, ConnectionInfo connectionInfo, XStream xstream, Client client, MediaType mediaType) {
        super(connectionInfo, xstream);
        this.client = Check.notNull(client, Client.class);
        this.mediaType = Check.notNull(mediaType, MediaType.class);
        this.subsystemProviders = subsystemProviders;
        this.getLogger().debug("Client created for media-type {} and connection {}", (Object)mediaType, (Object)connectionInfo);
        this.initializeConnection(connectionCondition);
        this.context = Maps.newHashMap();
        this.context.put(NexusClient.class, this);
        this.context.put(ClientBuilder.Target.Factory.class, ClientBuilder.using((Client)client).toAccess(connectionInfo.getBaseUrl().toUrl()));
    }

    public Client getClient() {
        return this.client;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String resolvePath(String path) {
        return this.getConnectionInfo().getBaseUrl() + path;
    }

    public String resolveServicePath(String path) {
        return this.resolvePath("service/local/" + path);
    }

    public WebResource.Builder serviceResource(String uri) {
        return (WebResource.Builder)this.getClient().resource(this.resolveServicePath(uri)).type(this.getMediaType()).accept(new MediaType[]{this.getMediaType()});
    }

    public WebResource.Builder serviceResource(String uri, MultivaluedMap<String, String> queryParameters) {
        return (WebResource.Builder)this.getClient().resource(this.resolveServicePath(uri)).queryParams(queryParameters).type(this.getMediaType()).accept(new MediaType[]{this.getMediaType()});
    }

    public WebResource.Builder uri(String uri) {
        return this.getClient().resource(this.resolvePath(uri)).getRequestBuilder();
    }

    public WebResource.Builder uri(String uri, MultivaluedMap<String, String> queryParameters) {
        return this.getClient().resource(this.resolvePath(uri)).queryParams(queryParameters).getRequestBuilder();
    }

    @Override
    public NexusStatus getStatus() {
        try {
            StatusResource response = ((StatusResourceResponse)this.serviceResource("status").get(StatusResourceResponse.class)).getData();
            return new NexusStatus(response.getAppName(), response.getFormattedAppName(), response.getVersion(), response.getApiVersion(), response.getEditionLong(), response.getEditionShort(), response.getState(), response.getInitializedAt(), response.getStartedAt(), response.getLastConfigChange(), -1L, response.isFirstStart(), response.isInstanceUpgraded(), response.isConfigurationUpgraded(), response.getBaseUrl());
        }
        catch (UniformInterfaceException e) {
            throw this.convert(e);
        }
        catch (ClientHandlerException e) {
            throw this.convert(e);
        }
    }

    @Override
    public synchronized void close() {
        try {
            if (this.client != null) {
                this.client.destroy();
                this.client = null;
            }
        }
        finally {
            super.close();
        }
    }

    @Override
    protected <S> S createSubsystem(Class<S> subsystemType) throws IllegalArgumentException {
        Preconditions.checkNotNull(subsystemType, (Object)"subsystemType cannot be null");
        for (SubsystemProvider subsystemProvider : this.subsystemProviders) {
            Object subsystem = subsystemProvider.get(subsystemType, this.context);
            if (subsystem == null) continue;
            Preconditions.checkState((boolean)subsystemType.isAssignableFrom(subsystem.getClass()), (String)"Subsystem '%s' created by '%s' is not an instance of '%s'", (Object[])new Object[]{subsystem, subsystemProvider, subsystemType.getSimpleName()});
            return subsystemType.cast(subsystem);
        }
        throw new IllegalArgumentException("No " + SubsystemProvider.class.getName() + " was able to create a subsystem of type" + subsystemType.getName());
    }

    public NexusClientNotFoundException convertIf404(UniformInterfaceException e) {
        ClientResponse response = e.getResponse();
        if (ClientResponse.Status.NOT_FOUND.equals((Object)response.getClientResponseStatus())) {
            return new NexusClientNotFoundException(this.getMessageIfPresent(ClientResponse.Status.NOT_FOUND.getStatusCode(), e), response.getClientResponseStatus().getReasonPhrase(), this.getResponseBody(response));
        }
        return null;
    }

    public NexusClientBadRequestException convertIf400(UniformInterfaceException e) {
        ClientResponse response = e.getResponse();
        if (ClientResponse.Status.BAD_REQUEST.equals((Object)response.getClientResponseStatus())) {
            return new NexusClientBadRequestException(this.getMessageIfPresent(ClientResponse.Status.BAD_REQUEST.getStatusCode(), e), response.getClientResponseStatus().getReasonPhrase(), this.getResponseBody(response));
        }
        return null;
    }

    public NexusClientAccessForbiddenException convertIf403(UniformInterfaceException e) {
        ClientResponse response = e.getResponse();
        if (ClientResponse.Status.FORBIDDEN.equals((Object)response.getClientResponseStatus())) {
            return new NexusClientAccessForbiddenException(this.getMessageIfPresent(ClientResponse.Status.FORBIDDEN.getStatusCode(), e), response.getClientResponseStatus().getReasonPhrase(), this.getResponseBody(response));
        }
        return null;
    }

    public NexusClientErrorResponseException convertIf400WithErrorMessage(UniformInterfaceException e) {
        ClientResponse response = e.getResponse();
        if (ClientResponse.Status.BAD_REQUEST.equals((Object)response.getClientResponseStatus())) {
            String body = this.getResponseBody(response);
            ErrorResponse errorResponse = null;
            try {
                errorResponse = (ErrorResponse)this.getXStream().fromXML(body, (Object)new ErrorResponse());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (errorResponse != null) {
                ArrayList<NexusClientErrorResponseException.ErrorMessage> errors = new ArrayList<NexusClientErrorResponseException.ErrorMessage>(errorResponse.getErrors().size());
                for (ErrorMessage message : errorResponse.getErrors()) {
                    errors.add(new NexusClientErrorResponseException.ErrorMessage(message.getId(), message.getMsg()));
                }
                return new NexusClientErrorResponseException(response.getClientResponseStatus().getReasonPhrase(), body, errors);
            }
        }
        return null;
    }

    public NexusClientException convert(UniformInterfaceException e) {
        NexusClientException exception = this.convertIfKnown(e);
        if (exception != null) {
            return exception;
        }
        return new NexusClientResponseException(this.getMessageIfPresent(e.getResponse().getClientResponseStatus().getStatusCode(), e), e.getResponse().getClientResponseStatus().getStatusCode(), e.getResponse().getClientResponseStatus().getReasonPhrase(), this.getResponseBody(e.getResponse()));
    }

    public NexusClientException convertIfKnown(UniformInterfaceException e) {
        NexusClientResponseException exception = this.convertIf404(e);
        if (exception != null) {
            return exception;
        }
        exception = this.convertIf403(e);
        if (exception != null) {
            return exception;
        }
        exception = this.convertIf400WithErrorMessage(e);
        if (exception != null) {
            return exception;
        }
        exception = this.convertIf400(e);
        if (exception != null) {
            return exception;
        }
        return null;
    }

    public NexusClientException convert(ClientHandlerException e) {
        throw new NexusClientHandlerException(e);
    }

    public String getResponseBody(ClientResponse response) {
        try {
            byte[] body = IOUtils.toByteArray((InputStream)response.getEntityInputStream());
            response.setEntityInputStream((InputStream)new ByteArrayInputStream(body));
            return IOUtils.toString((byte[])body, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException("Jersey unexpectedly refused to rewind buffered entity.");
        }
    }

    private String getMessageIfPresent(int status, UniformInterfaceException e) {
        if (e instanceof ContextAwareUniformInterfaceException) {
            return ((ContextAwareUniformInterfaceException)e).getMessage(status);
        }
        return null;
    }
}

