/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.rest;

import org.sonatype.nexus.client.internal.util.Check;
import org.sonatype.nexus.client.rest.AuthenticationInfo;
import org.sonatype.nexus.client.rest.Protocol;

public class ProxyInfo {
    private final Protocol proxyProtocol;
    private final String proxyHost;
    private final int proxyPort;
    private final AuthenticationInfo proxyAuthentication;

    public ProxyInfo(Protocol proxyProtocol, String proxyHost, int proxyPort, AuthenticationInfo proxyAuthentication) {
        this.proxyProtocol = Check.notNull(proxyProtocol, Protocol.class);
        this.proxyHost = Check.notBlank(proxyHost, "proxyHost");
        this.proxyPort = Check.argument(proxyPort > 0 && proxyPort < 65536, proxyPort, "proxyPort out of boundaries (0 < proxyPort < 65536)!");
        this.proxyAuthentication = proxyAuthentication;
    }

    public Protocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public AuthenticationInfo getProxyAuthentication() {
        return this.proxyAuthentication;
    }

    public String toString() {
        return "ProxyInfo[proxyProtocol=" + (Object)((Object)this.proxyProtocol) + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyAuthentication=" + this.proxyAuthentication + "]";
    }
}

