/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.core.condition;

import org.sonatype.nexus.client.core.Condition;
import org.sonatype.nexus.client.core.NexusStatus;
import org.sonatype.nexus.client.core.condition.internal.GenericVersionScheme;
import org.sonatype.nexus.client.core.condition.internal.InvalidVersionSpecificationException;
import org.sonatype.nexus.client.core.condition.internal.Version;
import org.sonatype.nexus.client.core.condition.internal.VersionConstraint;
import org.sonatype.nexus.client.internal.util.Check;

public abstract class VersionConditions
implements Condition {
    private static final VersionConstraint POST_1_8_VERSIONS = VersionConditions.parseVersionConstraint("(1.8.99,)");
    private static final VersionConstraint POST_1_9_VERSIONS = VersionConditions.parseVersionConstraint("(1.9.99,)");
    private static final VersionConstraint POST_2_0_VERSIONS = VersionConditions.parseVersionConstraint("(2.0.99,)");
    private static final VersionConstraint POST_2_1_VERSIONS = VersionConditions.parseVersionConstraint("(2.1.99,)");
    private static final VersionConstraint POST_2_2_VERSIONS = VersionConditions.parseVersionConstraint("(2.2.99,)");
    private static final VersionConstraint POST_2_3_VERSIONS = VersionConditions.parseVersionConstraint("(2.3.99,)");
    private static final VersionConstraint POST_2_4_VERSIONS = VersionConditions.parseVersionConstraint("(2.4.99,)");
    private static final VersionConstraint POST_2_5_VERSIONS = VersionConditions.parseVersionConstraint("(2.5.99,)");
    private static final VersionConstraint POST_2_6_VERSIONS = VersionConditions.parseVersionConstraint("(2.6.99,)");

    public static Condition anyModernVersion() {
        return new VersionCondition(POST_1_8_VERSIONS);
    }

    public static Condition any20AndLaterVersion() {
        return new VersionCondition(POST_1_9_VERSIONS);
    }

    public static Condition any21AndLaterVersion() {
        return new VersionCondition(POST_2_0_VERSIONS);
    }

    public static Condition any22AndLaterVersion() {
        return new VersionCondition(POST_2_1_VERSIONS);
    }

    public static Condition any23AndLaterVersion() {
        return new VersionCondition(POST_2_2_VERSIONS);
    }

    public static Condition any24AndLaterVersion() {
        return new VersionCondition(POST_2_3_VERSIONS);
    }

    public static Condition any25AndLaterVersion() {
        return new VersionCondition(POST_2_4_VERSIONS);
    }

    public static Condition any26AndLaterVersion() {
        return new VersionCondition(POST_2_5_VERSIONS);
    }

    public static Condition any27AndLaterVersion() {
        return new VersionCondition(POST_2_6_VERSIONS);
    }

    public static Condition withVersion(String versionRange) {
        return new VersionCondition(VersionConditions.parseVersionConstraint(versionRange));
    }

    private static VersionConstraint parseVersionConstraint(String versionConstraint) {
        try {
            return new GenericVersionScheme().parseVersionConstraint(versionConstraint);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Unable to parse version constraint: " + versionConstraint, e);
        }
    }

    private static Version parseVersion(String version) {
        try {
            return new GenericVersionScheme().parseVersion(version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Unable to parse version: " + version, e);
        }
    }

    private static class VersionCondition
    implements Condition {
        private final VersionConstraint suitableVersions;

        private VersionCondition(VersionConstraint suitableVersions) {
            this.suitableVersions = Check.notNull(suitableVersions, VersionConstraint.class);
        }

        @Override
        public boolean isSatisfiedBy(NexusStatus status) {
            Version version = VersionConditions.parseVersion(status.getVersion());
            return this.suitableVersions.containsVersion(version);
        }

        @Override
        public String explainNotSatisfied(NexusStatus status) {
            return String.format("(version \"%s\" contained in \"%s\")", status.getVersion(), this.suitableVersions);
        }
    }
}

