/*
 * Copyright @ 2020 - present 8x8, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jitsi.jicofo

import io.kotest.core.spec.style.ShouldSpec
import io.kotest.matchers.shouldBe
import org.jitsi.config.withNewConfig

class OctoConfigTest : ShouldSpec() {
    init {
        context("Enabled flag") {
            // Note that there's a corresponding flag in the JVB and these two
            // MUST be in sync (otherwise bridges will crash because they won't
            // know how to deal with octo channels).
            context("default") {
                OctoConfig.config.enabled shouldBe false
            }
            context("disabled") {
                withNewConfig("jicofo.octo.enabled=false") {
                    OctoConfig.config.enabled shouldBe false
                }
            }
            context("enabled") {
                withNewConfig("jicofo.octo.enabled=true") {
                    OctoConfig.config.enabled shouldBe true
                }
            }
        }
    }
}
