/*
 * Copyright @ 2021 - present 8x8, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jitsi.jicofo.conference.source

import kotlin.jvm.Throws

/** The supported semantics for [SsrcGroup] */
enum class SsrcGroupSemantics {
    /** Simulcast. */
    Sim,

    /** Flow ID, used for RTX. */
    Fid;

    override fun toString() = super.toString().uppercase()

    companion object {
        /** Parse a string case-insensitively. */
        @Throws(NoSuchElementException::class)
        fun fromString(str: String): SsrcGroupSemantics =
            values().first { it.toString().lowercase() == str.lowercase() }
    }
}
