# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
# Given a config-file path and a host name, we extract the info from the file #
# and  save it is @cfg.  We also look for a few specific lines and save their #
# data in some other global arrays.                                           #
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
# Read the config file for a host.
sub cfgload {
	local($cfile,$host) = @_;
	local($line,$opt);
	@cfg = ();
	unless (open(CFG,$cfile)) {
		print V "$P: Can't read config file \"$cfile\" ($!)\n" if $V>1;
		return undef;
	}
	print V "$P: Reading config info from \"$cfile\"\n" if $V>1;
	for $line (<CFG>) {
		$line =~ s/[\s\r]+$//;
		if ($line =~ /^[+0-9]*\s*(C:)\s*(.*)/) {	# C: Config file name
			$Getcmd{"$1$host"} = $2;
			print V "$P: Get command \"$2\" for $host (from cfg file)\n" if $V>1;
		} elsif ($line =~ /^[+0-9]*\s*(D:)\s*(\d+)/) {	# D: Depth limit
			$Getcmd{"$1$host"} = $2;
			print V "$P: Depth limit \"$2\" for $host (from cfg file)\n" if $V>1;
		} elsif ($line =~ /^[+0-9]*\s*(L:)\s*(\d+)/) {	# L: Line max before giving up
			$maxlines = $2;
			print V "$P: maxlines=$maxlines for $host (from cfg file)\n" if $V>1;
		} elsif ($line =~ /^[+0-9]*\s*(O:)\s*(\d+)/) {	# O: Option
			$opt = uc($2);
			if ($opt eq 'CGI') {
				print V "$P: Allow CGI calls for $host.\n" if $V>1;
				$allowcgi = 1;
			} else {
				print V "$P: Option '$opt' not recognized.\n" if $V>1;
			}
		} else {
			print V "$P: Config line \"$line\" not matched.\n" if $V>1;
		}
		push @cfg, $line;
	}
	close CFG;
	return 1;
}
1;
