# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
# Here, we take a URL that is a path to something, plus an href  that #
# is  believed  to  be a relative to the URL, and combine them into a #
# URL.  The main point of this routine is to try to  correctly  strip #
# off the last field from the path.                                   #
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
sub URLhref {
	local($path,$href) = @_;
	local($url,$prot,$host,$rest);
	my $id = "URLhref";
	if ($href =~ s"^/+"") {				# Does href have initial slash?
		print V "$id: /href \"/$href\"\n" if $V>3 || ($href =~ /McQuillensSqueez/);
		if (($prot,$host,$rest) = ($path =~ m"^([^/:]+)://([^/]+)(/.*)$")) {
			print V "$id: \"$path\" trimmed \"$rest\"\n" if $V>3;
			$path = "$prot://$host";
		}
	} elsif ($href =~ m"^\w*:") {
		print V "$id: URL \"$href\"\n" if $V>3 || ($href =~ /McQuillensSqueez/);
		return $href;
	} else {
		if ($path =~ s"/([^/]+)$"") {			# No: Trim path to directory.
			print V "$id: \"$path\" removed \"$1\"\n" if $V>3 || ($path =~ /McQuillensSqueez/);
		}
	}
	$path =~ s"/+$"";
	$url = &URLtrim("$path/$href");
	print V "$id: \"$path\" + \"$href\" =\n\t\"$url\"\n" if $V>3 || ($href =~ '^\$') || ($path =~ /McQuillensSqueez/);
	$url;
}
1;
