public class InnerclassTest {
        private int count;

        public InnerclassTest() throws Exception {
                count = 0;
                // Local innerclass
                class Local {
                        private String local;
                        public Local() {
                                this.local = "Local";
                        }
                        public String toString() {
                                return this.local + ": count = " + ++count;
                        }
                }
                String local = new Local().toString();

                // Anonymous innerclass
                String anonymous = new Anonymous() {
                        public String toString() {
                                return "Anonymous: count = " + ++count;
                        }
                }.toString();

                String inner = new Innerclass().toString();
                String extended = new Extended().toString();
		if (local.equals("Local: count = 1") )
                	System.out.println("PASSED: "+local);
		else
			throw new Exception("Incorrect count: "+local);
		if (anonymous.equals("Anonymous: count = 2") )
                	System.out.println("PASSED: "+anonymous);
		else
			throw new Exception("Incorrect count: "+anonymous);
		if (inner.equals("Innerclass: count = 3") )
                	System.out.println("PASSED: "+inner);
		else
			throw new Exception("Incorrect count: "+inner);
		if (extended.equals("Extended: count = 4") )
                	System.out.println("PASSED: "+extended);
		else
			throw new Exception("Incorrect count: "+extended);
        }

        public static void main(String[] args) {
		try {
                	new InnerclassTest();
		} catch (Exception e) {
			System.out.println("FAILED: "+e);
		}
        }

        // Innerclass interface
        protected interface Anonymous {}

        // Innerclass
        protected class Innerclass {
                protected String inner;
                public Innerclass() {
                        this.inner = "Innerclass";
                }
                public String toString() {
                        return this.inner + ": count = " + ++count;
                }
        }

        // Extended innerclass
        protected class Extended extends Innerclass {
                public Extended() {
                        this.inner = "Extended";
                }
        }
}
