/* -*- Mode: C; c-file-style: "gnu" -*-
   field.c -- spew dealing with fields.
   Created: Chris Toshok <toshok@hungry.com>, 5-Dec-1997.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"
#include "japharh.h"

extern JNIEnv *the_env;

void
spew_field(FILE *fp, FieldStruct *field)
{
  Signature *sig = SIG_parseFromJavaSig(the_env, field->sig_str);

  output_location_for_field(fp, field);

  output_begin_type(fp);
  output_begin_access_flags(fp);
  spew_access_flags_pretty(fp, field->access_flags);
  output_end_access_flags(fp);

  fprintf(fp, " %s",
	  SIG_formatToJavaSource(the_env, sig));
  output_end_type(fp);

  output_begin_field_name(fp);
  fprintf(fp, " %s",
	  field->name);
  output_end_field_name(fp);

  fprintf(fp, ";");

  output_newline(fp);
}
