/* -*- Mode: C; c-file-style: "gnu" -*-
   cmds.h -- debugger commands.
   Created: Chris Toshok <toshok@hungry.com>, 30-Nov-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998 The Hungry Programmers

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _japhard_cmds_h
#define _japhard_cmds_h

#include "readline/readline.h"

typedef struct {
  char *name;		/* User printable name of the function. */
  Function *func;	/* Function to call to do the job. */
  char *doc;		/* Documentation for this function. */
} COMMAND;

extern COMMAND commands[];

extern int cmd_list(void);
extern int cmd_info(char *arg);
extern int cmd_print(char *arg);
extern int cmd_printobj(char *arg);
extern int cmd_help(char *arg);
extern int cmd_run(char *arg);
extern int cmd_step(void);
extern int cmd_next(void);
extern int cmd_cont(void);
extern int cmd_break(char *arg);
extern int cmd_enablebp(char *arg);
extern int cmd_disablebp(char *arg);
extern int cmd_deletebp(char *arg);
extern int cmd_start(char *name);
extern int cmd_stop(char *name);
extern int cmd_switch(char *name);
extern int cmd_quit(void);
extern int cmd_where(char *arg);
extern int cmd_up(char *arg);
extern int cmd_down(char *arg);
extern int cmd_gc(void);
extern int cmd_finalize(void);

#endif /* _japhard_cmds_h */
