/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"
#include "interp.h"
#include "native-threads.h"

#define MYLOG "Thread"

/* XXX Is this the correct implementation?  Stolen from kaffe 0.10.0 */
void
suspend_thread(jobject thread_jobj, JThreadInfo *thread_info)
{
  HMonitor monitor = MONITOR_getForObject(thread_jobj);
  MONITOR_enter(monitor);
#if WITH_JVMDI
  STATE(thread_info) = STATE_SUSPENDED;
#endif
  MONITOR_wait(monitor);
  MONITOR_exit(monitor);
}

/* XXX Is this the correct implementation?  Stolen from kaffe 0.10.0 */
void
resume_thread(jobject thread_jobj, JThreadInfo *thread_info)
{
  HMonitor monitor = MONITOR_getForObject(thread_jobj);
  MONITOR_enter(monitor);
  /* XXX How do we make sure that we start the one which is suspended? */
  MONITOR_notifyOne(monitor);
#if WITH_JVMDI
  STATE(thread_info) = STATE_RUNNING;
#endif
  MONITOR_exit(monitor);
}
