/* -*- Mode: C; c-file-style: "gnu" -*-
   stubgc.c -- stub gc that doesn't free anything.
   Created: Chris Toshok <toshok@hungry.com>, 1-Oct-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "log.h"

#include "gc.h"
#include "jniint.h"

#include <stdlib.h>

#define MYLOG "GC"

typedef struct {
  JGC_struct _gc_vtable;

  jboolean verbose;
  jint num_objects_allocated;
  jint num_classes_allocated;
} stubgc_struct;

static void
stubgc_initCollector(JavaVM *vm, jint initialHeapSize, jint segmentSize, jboolean verbose)
{
  stubgc_struct *gcinfo = (stubgc_struct*)((HungryJavaVM*)vm)->_gc;

  JAVARLOG0(MYLOG, 0, "Japhar Warning: Using stub garbage collector.  "
	    "No collections will occur.\n");

  gcinfo->verbose = verbose;

  if (gcinfo->verbose)
    printf ("[STUBGC InitCollector(initial heap size = %d, segment size = %d)]\n",
	    initialHeapSize, segmentSize);
}

static void
stubgc_shutdownCollector(JavaVM *vm, jboolean finalizeOnExit)
{
  stubgc_struct *gcinfo = (stubgc_struct*)((HungryJavaVM*)vm)->_gc;

  if (gcinfo->verbose)
    printf ("[STUBGC ShutdownCollecto(finalizeOnExit = %d)]\n",
	    finalizeOnExit);
}

static void*
stubgc_allocObject(JavaVM *vm, size_t size)
{
  stubgc_struct *gcinfo = (stubgc_struct*)((HungryJavaVM*)vm)->_gc;

  gcinfo->num_objects_allocated++;
    
  return calloc(1, size);
}

static void*
stubgc_allocClazzFile(JavaVM *vm, size_t size)
{
  stubgc_struct *gcinfo = (stubgc_struct*)((HungryJavaVM*)vm)->_gc;

  gcinfo->num_classes_allocated++;

  return calloc(1, size);
}

static void
stubgc_runCollector(JavaVM *vm)
{
  stubgc_struct *gcinfo = (stubgc_struct*)((HungryJavaVM*)vm)->_gc;

  if (gcinfo->verbose)
    printf ("[STUBGC runCollector()]\n");
}

static void
stubgc_runFinalizers(JavaVM *vm)
{
  stubgc_struct *gcinfo = (stubgc_struct*)((HungryJavaVM*)vm)->_gc;

  if (gcinfo->verbose)
    printf ("[STUBGC runFinalizers()]\n");
}

static void
stubgc_addThread(JavaVM *vm, JNIEnv *env)
{
  stubgc_struct *gcinfo = (stubgc_struct*)((HungryJavaVM*)vm)->_gc;

  if (gcinfo->verbose)
    printf ("[STUBGC addThread(env = %p)]\n", env);
}

static void
stubgc_removeThread(JavaVM *vm, JNIEnv *env)
{
  stubgc_struct *gcinfo = (stubgc_struct*)((HungryJavaVM*)vm)->_gc;

  if (gcinfo->verbose)
    printf ("[STUBGC removeThread(env = %p)]\n", env);
}

static void
stubgc_printStats(JavaVM *vm, FILE *out)
{
}

static stubgc_struct stubgc = {
  {
    stubgc_initCollector,
    stubgc_shutdownCollector,
    stubgc_allocObject,
    stubgc_allocClazzFile,
    stubgc_runCollector,
    stubgc_runFinalizers,
    stubgc_addThread,
    stubgc_removeThread,
    stubgc_printStats
  },
  JNI_FALSE,
  0,
  0
};

JGC_struct *STUB_GC = (JGC_struct*)&stubgc;
