/* -*- Mode: C; c-file-style: "gnu" -*-
   method.c -- method lookup.
   Created: Chris Toshok <toshok@hungry.com>, 23-Aug-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "objects.h"
#include "method.h"
#include "ClazzFile.h"

MethodStruct *
find_method(JNIEnv *env,
	    jclass cls,
	    const char *name,
	    const char *sig)
{
  int method_num;
  ClazzFile* clazz = jclass_to_clazzfile(env, cls);
  MethodStruct *method = NULL;

  if (clazz == NULL)
    {
      /* XXX throw something */
      return NULL;
    }

  for (method_num = 0; method_num < clazz->num_methods; method_num++)
    {
      MethodStruct *cur_method = clazz->methods[method_num];
      
      if (!strcmp(cur_method->name, name)
	  && !strcmp(cur_method->sig_str, sig)
	  && !(cur_method->access_flags & ACC_STATIC))
	{
	  method = cur_method;
	  break;
	}
    }

  return method;
}

MethodStruct *
find_static_method(JNIEnv *env,
		   jclass cls,
		   const char *name,
		   const char *sig)
{
  int method_num;
  ClazzFile* clazz = jclass_to_clazzfile(env, cls);
  MethodStruct *method = NULL;

  if (clazz == NULL)
    {
      /* XXX throw something */
      return NULL;
    }

  for (method_num = 0; method_num < clazz->num_methods; method_num++)
    {
      MethodStruct *cur_method = clazz->methods[method_num];
      
      if (!strcmp(cur_method->name, name)
	  && !strcmp(cur_method->sig_str, sig)
	  && cur_method->access_flags & ACC_STATIC)
	{
	  method = cur_method;
	  break;
	}
    }

  return method;
}
