/* -*- Mode: C; c-file-style: "gnu" -*-
   japharPlugin.cpp -- the mozilla plugin entry point for the japhar OJI plugin.
   Created: Chris Toshok <toshok@hungry.com>, 8-Aug-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"

#include "nsplugin.h"
#include "japharJVMPlugin.h"

static NS_DEFINE_IID(kIPluginIID, NS_IPLUGIN_IID);

nsresult
NSGetFactory(const nsCID &aClass,
	     nsIFactory **aFactory)
{
  nsIFactory* fact;
  nsresult result;

  printf ("In NSGetFactory.\n");
  if (aClass.Equals(kIPluginIID)) {
    japharJVMPlugin* jvmplugin = new japharJVMPlugin();
    if (jvmplugin == NULL) 
      {
	printf ("  + returning NS_ERROR_OUT_OF_MEMORY\n");
	return NS_ERROR_OUT_OF_MEMORY;
      }

    static NS_DEFINE_IID(kIFactoryIID, NS_IFACTORY_IID);
    if ((result = jvmplugin->QueryInterface(kIFactoryIID,
					    (void**)&fact)) != NS_OK)
      {
	printf ("  + error querying for NS_IFACTORY_IID\n");
	return result;
      }

    *aFactory = fact;
    printf ("  + returning NS_OK\n");
    return NS_OK;
  }
  printf ("  + returning NS_ERROR_FAILURE\n");
  return NS_ERROR_FAILURE;    // XXX right error?
}
