/* -*- Mode: C; c-file-style: "gnu" -*-
   appletcontext.cpp -- native methods for com.hungry.java.japhar.JapharAppletContext
   Created: Chris Toshok <toshok@hungry.com>, 9-Sep-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>

#include "jni.h"
#include "japharJVMPluginInstance.h"

static japharJVMPluginInstance*
get_plugin(JNIEnv *env,
	   jobject obj)
{
  jclass context_class = env->GetObjectClass(obj);
  jfieldID plugin_id = env->GetFieldID(context_class, "plugin_id", "I");
  japharJVMPluginInstance *inst = (japharJVMPluginInstance*)env->GetIntField(obj, plugin_id);

  return inst;
}

static char *
jstring2charptr(JNIEnv *env, jstring jstr)
{
  char *str_copy;
  const jbyte *str_chars;
  int str_length;
  str_chars = env->GetStringUTFChars(jstr, NULL);
  str_length = env->GetStringUTFLength(jstr) + 1;
  str_copy = (char*) malloc(str_length * sizeof(char));
  strncpy(str_copy, (const char*)str_chars, str_length);
  env->ReleaseStringUTFChars(jstr, str_chars);
  str_copy[str_length-1] = 0; /* Make sure the string is zero terminated */
  return str_copy;
}

extern "C" JNIEXPORT jobject JNICALL
Java_com_hungry_java_japhar_JapharAppletContext_getAudioClip(JNIEnv *env,
							     jobject obj,
							     jobject )
{
}

extern "C" JNIEXPORT jobject JNICALL
Java_com_hungry_java_japhar_JapharAppletContext_getImage(JNIEnv *env,
							 jobject obj,
							 jobject )
{
}

extern "C" JNIEXPORT jobject JNICALL
Java_com_hungry_java_japhar_JapharAppletContext_getApplet(JNIEnv *env,
							  jobject obj,
							  jstring name)
{
}

extern "C" JNIEXPORT jobject JNICALL
Java_com_hungry_java_japhar_JapharAppletContext_getApplets(JNIEnv *env,
							   jobject enumeration)
{
}

extern "C" JNIEXPORT void JNICALL
Java_com_hungry_java_japhar_JapharAppletContext_showDocument(JNIEnv *env,
							     jobject obj,
							     jobject url,
							     jstring target)
{
  printf ("Java_com_hungry_java_japhar_JapharAppletContext_showDocument\n");
  japharJVMPluginInstance *inst = get_plugin(env, obj);
  nsIPluginInstancePeer *peer;
  nsISupports *browser = inst->GetBrowser();
  nsIPluginManager *pluginman;

  if (inst->GetPeer(&peer) != NS_OK)
    return; /* XXX throw an exception? */

  static NS_DEFINE_IID(kIPluginManagerIID, NS_IPLUGINMANAGER_IID);
  if (browser->QueryInterface(kIPluginManagerIID,
			      (void**)&pluginman) != NS_OK)
    {
      return; /* throw an exception? */
    }
  else
    {
      jclass url_class = env->GetObjectClass(url);
      jmethodID toString = env->GetMethodID(url_class, "toString", "()Ljava/lang/String;");
      jstring url_string = env->CallObjectMethod(url, toString);
      char *url_str = jstring2charptr(env, url_string);
      char *target_str = jstring2charptr(env, target);

      printf ("calling geturl(%s,%s)\n", url_str, target_str);
      nsresult res = pluginman->GetURL(inst, url_str, target_str);
      if (res != NS_OK)
	printf ("pluginman->GetURL failed with res=%d\n", res);
    }
    
}

extern "C" JNIEXPORT void JNICALL
Java_com_hungry_java_japhar_JapharAppletContext_showStatus(JNIEnv *env,
							   jobject obj,
							   jstring msg)
{
  japharJVMPluginInstance *inst = get_plugin(env, obj);
  nsIPluginInstancePeer *peer;
  char* msg_str = jstring2charptr(env, msg); // we leak this.
    
  if (inst->GetPeer(&peer) != NS_OK)
    return; /* XXX throw an exception? */
  else
    {
      peer->ShowStatus(msg_str);
      free(msg_str);
    }
}

extern "C" JNIEXPORT jstring JNICALL
Java_com_hungry_java_japhar_JapharAppletContext_getParameter(JNIEnv *env,
							     jobject obj,
							     jstring param_name)
{
  japharJVMPluginInstance *inst = get_plugin(env, obj);
  nsIPluginInstancePeer *peer;
  char* param_str = jstring2charptr(env, param_name); // we leak this.
    
  if (inst->GetPeer(&peer) != NS_OK)
    return NULL; /* XXX throw an exception? */
  else
    {
      nsIPluginTagInfo2 *info2;
      static NS_DEFINE_IID(kIPluginTagInfo2IID, NS_IPLUGINTAGINFO2_IID);
	    
      if (peer->QueryInterface(kIPluginTagInfo2IID,
			       (void**)&info2) == NS_OK)
	{
	  const char *value;
	  if (info2->GetParameter(param_str, &value) == NS_OK)
	    {
	      jstring str = env->NewStringUTF(value);
	      return str;
	    }
	  else
	    return NULL;
	}
      else
	{
	  return NULL;
	}
    }
}
