/* -*- Mode: C; c-file-style: "gnu" -*-
   initids.c -- initIDs methods for a whole slew of awt components.
   Created: Chris Toshok <toshok@hungry.com>, 18-Nov-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "jni.h"

#define GET_FINAL_INT(fieldname) do { \
  jfieldID field = (*env)->GetStaticFieldID(env, cls, #fieldname, "I"); \
  fieldname = (*env)->GetStaticIntField(env, cls, field); \
} while (0)

JNIEXPORT void JNICALL
Java_java_awt_AWTEvent_initIDs(JNIEnv *env,
			       jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Toolkit_initIDs(JNIEnv *env,
			      jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Container_initIDs(JNIEnv *env,
				jclass cls)
{
}

jint DEFAULT_CURSOR = -1;
jint CROSSHAIR_CURSOR;
jint TEXT_CURSOR;
jint WAIT_CURSOR;
jint SW_RESIZE_CURSOR;
jint SE_RESIZE_CURSOR;
jint NW_RESIZE_CURSOR;
jint NE_RESIZE_CURSOR;
jint N_RESIZE_CURSOR;
jint S_RESIZE_CURSOR;
jint W_RESIZE_CURSOR;
jint E_RESIZE_CURSOR;
jint HAND_CURSOR;
jint MOVE_CURSOR;

JNIEXPORT void JNICALL
Java_java_awt_Cursor_initIDs(JNIEnv *env,
			     jclass cls)
{
  jfieldID field;

  GET_FINAL_INT(DEFAULT_CURSOR);
  GET_FINAL_INT(CROSSHAIR_CURSOR);
  GET_FINAL_INT(TEXT_CURSOR);
  GET_FINAL_INT(WAIT_CURSOR);
  GET_FINAL_INT(SW_RESIZE_CURSOR);
  GET_FINAL_INT(SE_RESIZE_CURSOR);
  GET_FINAL_INT(NW_RESIZE_CURSOR);
  GET_FINAL_INT(NE_RESIZE_CURSOR);
  GET_FINAL_INT(N_RESIZE_CURSOR);
  GET_FINAL_INT(S_RESIZE_CURSOR);
  GET_FINAL_INT(W_RESIZE_CURSOR);
  GET_FINAL_INT(E_RESIZE_CURSOR);
  GET_FINAL_INT(HAND_CURSOR);
  GET_FINAL_INT(MOVE_CURSOR);
}

JNIEXPORT void JNICALL
Java_java_awt_Frame_initIDs(JNIEnv *env,
			    jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Insets_initIDs(JNIEnv *env,
			     jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_MenuComponent_initIDs(JNIEnv *env,
				    jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_MenuBar_initIDs(JNIEnv *env,
			      jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_MenuItem_initIDs(JNIEnv *env,
			       jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Menu_initIDs(JNIEnv *env,
			   jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Label_initIDs(JNIEnv *env,
			    jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Button_initIDs(JNIEnv *env,
			     jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Checkbox_initIDs(JNIEnv *env,
			       jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_CheckboxMenuItem_initIDs(JNIEnv *env,
				       jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Color_initIDs(JNIEnv *env,
			    jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Component_initIDs(JNIEnv *env,
				jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Dialog_initIDs(JNIEnv *env,
			     jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Dimension_initIDs(JNIEnv *env,
				jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Event_initIDs(JNIEnv *env,
			    jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_event_InputEvent_initIDs(JNIEnv *env,
				       jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_event_KeyEvent_initIDs(JNIEnv *env,
				     jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_image_BufferedImage_initIDs(JNIEnv *env,
					  jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_image_ColorModel_initIDs(JNIEnv *env,
				       jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_image_Raster_initIDs(JNIEnv *env,
				   jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_image_SampleModel_initIDs(JNIEnv *env,
					jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_image_SinglePixelPackedSampleModel_initIDs(JNIEnv *env,
							 jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_FileDialog_initIDs(JNIEnv *env,
				 jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Font_initIDs(JNIEnv *env,
			   jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Rectangle_initIDs(JNIEnv *env,
				jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_ScrollPane_initIDs(JNIEnv *env,
				 jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Scrollbar_initIDs(JNIEnv *env,
				jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_TextArea_initIDs(JNIEnv *env,
			       jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_TextField_initIDs(JNIEnv *env,
				jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_awt_Window_initIDs(JNIEnv *env,
			     jclass cls)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFontPeer_initIDs(JNIEnv *env,
				     jclass cls)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_FontDescriptor_initIDs(JNIEnv *env,
				    jclass cls)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_image_ShortComponentRaster_initIDs(JNIEnv *env,
						jclass cls)
{
}

void
Java_sun_awt_PlatformFont_initIDs(JNIEnv *env,
                                  jclass cls)
{
}

