/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"

#include "dynamic_loading.h"

#if !defined(HAVE_LIBFFI) || !defined HAVE_DLL || defined PROFILING

#include "java_lang_Class_stubs.c"
#include "java_lang_ClassLoader_stubs.c"
#include "java_lang_Compiler_stubs.c"
#include "java_lang_Double_stubs.c"
#include "java_lang_Float_stubs.c"
#include "java_lang_Math_stubs.c"
#include "java_lang_Object_stubs.c"
#include "java_lang_Runtime_stubs.c"
#include "java_lang_SecurityManager_stubs.c"
#include "java_lang_String_stubs.c"
#include "java_lang_System_stubs.c"
#include "java_lang_Thread_stubs.c"
#include "java_lang_Throwable_stubs.c"
#if notyet
#include "java_lang_UNIXProcess_stubs.c"
#endif
sym_mapping java_lang_mappings[] = {
  /* JDK1.1 */
  MAPPING( Java_java_lang_Class_forName0_stub ),
  MAPPING( Java_java_lang_Class_getClassLoader0_stub ),
  MAPPING( Java_java_lang_Class_getComponentType_stub ),
  MAPPING( Java_java_lang_Class_getConstructors0_stub ),
  MAPPING( Java_java_lang_Class_getConstructor0_stub ),
  MAPPING( Java_java_lang_Class_getConstructors0_stub ),
  MAPPING( Java_java_lang_Class_getDeclaredClasses0_stub ),
  MAPPING( Java_java_lang_Class_getDeclaringClass_stub ),
  MAPPING( Java_java_lang_Class_getField0_stub ),
  MAPPING( Java_java_lang_Class_getFields0_stub ),
  MAPPING( Java_java_lang_Class_isInterface_stub ),
  MAPPING( Java_java_lang_Class_getInterfaces_stub ),
  MAPPING( Java_java_lang_Class_getMethod0_stub ),
  MAPPING( Java_java_lang_Class_getMethods0_stub ),
  MAPPING( Java_java_lang_Class_getModifiers_stub ),
  MAPPING( Java_java_lang_Class_getName_stub ),
  MAPPING( Java_java_lang_Class_getPrimitiveClass_stub ),
  MAPPING( Java_java_lang_Class_getProtectionDomain0_stub ),
  MAPPING( Java_java_lang_Class_getSigners_stub ),
  MAPPING( Java_java_lang_Class_getSuperclass_stub ),
  MAPPING( Java_java_lang_Class_isArray_stub ),
  MAPPING( Java_java_lang_Class_isAssignableFrom_stub ),
  MAPPING( Java_java_lang_Class_isInstance_stub ),
  MAPPING( Java_java_lang_Class_isInterface_stub ),
  MAPPING( Java_java_lang_Class_isPrimitive_stub ),
  MAPPING( Java_java_lang_Class_newInstance0_stub ),
  MAPPING( Java_java_lang_Class_setProtectionDomain0_stub ),
  MAPPING( Java_java_lang_Class_setSigners_stub ),
  /* JDK1.2 */
  MAPPING( Java_java_lang_Class_registerNatives_stub ),
  
#if notyet
  /* JDK1.1 */
  MAPPING( Java_java_lang_ClassLoader_init_stub ),
#endif

  MAPPING( Java_java_lang_ClassLoader_defineClass0_stub ),
  MAPPING( Java_java_lang_ClassLoader_findBootstrapClass_stub ),
  MAPPING( Java_java_lang_ClassLoader_findLoadedClass_stub ),
  MAPPING( Java_java_lang_ClassLoader_getCallerClassLoader_stub ),
  MAPPING( Java_java_lang_ClassLoader_resolveClass0_stub ),

  MAPPING( Java_java_lang_Compiler_registerNatives_stub ),

  MAPPING( Java_java_lang_Double_doubleToLongBits_stub ),
  MAPPING( Java_java_lang_Double_longBitsToDouble_stub ),
#if notyet
  /* JDK1.1 */
  MAPPING( Java_java_lang_Double_valueOf0_stub ),
#endif

  MAPPING( Java_java_lang_Float_floatToIntBits_stub ),
  MAPPING( Java_java_lang_Float_intBitsToFloat_stub ),

  MAPPING( Java_java_lang_Math_sin_stub ),
  MAPPING( Java_java_lang_Math_cos_stub ),
  MAPPING( Java_java_lang_Math_tan_stub ),
  MAPPING( Java_java_lang_Math_asin_stub ),
  MAPPING( Java_java_lang_Math_acos_stub ),
  MAPPING( Java_java_lang_Math_atan_stub ),
  MAPPING( Java_java_lang_Math_exp_stub ),
  MAPPING( Java_java_lang_Math_log_stub ),
  MAPPING( Java_java_lang_Math_sqrt_stub ),
  MAPPING( Java_java_lang_Math_IEEEremainder_stub ),
  MAPPING( Java_java_lang_Math_ceil_stub ),
  MAPPING( Java_java_lang_Math_floor_stub ),
  MAPPING( Java_java_lang_Math_rint_stub ),
  MAPPING( Java_java_lang_Math_atan2_stub ),
  MAPPING( Java_java_lang_Math_pow_stub ),

  /* JDK1.1 */
  MAPPING( Java_java_lang_Object_getClass_stub ),
  MAPPING( Java_java_lang_Object_hashCode_stub ),
  MAPPING( Java_java_lang_Object_clone_stub ),
  MAPPING( Java_java_lang_Object_notify_stub ),
  MAPPING( Java_java_lang_Object_notifyAll_stub ),
  MAPPING( Java_java_lang_Object_wait_stub ),

  /* JDK1.2 */
  MAPPING( Java_java_lang_Object_registerNatives_stub ),

  MAPPING( Java_java_lang_Runtime_exitInternal_stub ),
  MAPPING( Java_java_lang_Runtime_runFinalizersOnExit0_stub ),
  MAPPING( Java_java_lang_Runtime_execInternal_stub ),
  MAPPING( Java_java_lang_Runtime_freeMemory_stub ),
  MAPPING( Java_java_lang_Runtime_totalMemory_stub ),
  MAPPING( Java_java_lang_Runtime_gc_stub ),
#if 0
  /* JDK1.1 */
  MAPPING( Java_java_lang_Runtime_runFinalization_stub ),
#endif
  /* JDK1.2 */
  MAPPING( Java_java_lang_Runtime_runFinalization0_stub ),

  MAPPING( Java_java_lang_Runtime_traceInstructions_stub ),
  MAPPING( Java_java_lang_Runtime_traceMethodCalls_stub ),

  /* JDK1.1 */
#if notyet
  MAPPING( Java_java_lang_Runtime_initializeLinkerInternal_stub ),
  MAPPING( Java_java_lang_Runtime_buildLibName_stub ),
  MAPPING( Java_java_lang_Runtime_loadFileInternal_stub ),
#endif

  MAPPING( Java_java_lang_SecurityManager_getClassContext_stub ),
#if notyet
  /* JDK1.1 */
  MAPPING( Java_java_lang_SecurityManager_currentClassLoader_stub ),
#endif
  MAPPING( Java_java_lang_SecurityManager_classDepth_stub ),
#if notyet
  /* JDK1.1 */
  MAPPING( Java_java_lang_SecurityManager_classLoaderDepth_stub ),
#endif
  MAPPING( Java_java_lang_SecurityManager_currentLoadedClass0_stub ),

  MAPPING( Java_java_lang_String_intern_stub ),

  /* JDK1.1 */
  MAPPING( Java_java_lang_System_currentTimeMillis_stub ),
  MAPPING( Java_java_lang_System_arraycopy_stub ),
  MAPPING( Java_java_lang_System_identityHashCode_stub ),
  MAPPING( Java_java_lang_System_initProperties_stub ),

  /* JDK1.2 */
  MAPPING( Java_java_lang_System_registerNatives_stub ),

  /* JDK1.1 */
  MAPPING( Java_java_lang_Thread_currentThread_stub ),
  MAPPING( Java_java_lang_Thread_yield_stub ),
  MAPPING( Java_java_lang_Thread_sleep_stub ),
  MAPPING( Java_java_lang_Thread_start_stub ),
  MAPPING( Java_java_lang_Thread_isInterrupted_stub ),
  MAPPING( Java_java_lang_Thread_isAlive_stub ),
  MAPPING( Java_java_lang_Thread_countStackFrames_stub ),
  MAPPING( Java_java_lang_Thread_setPriority0_stub ),
  MAPPING( Java_java_lang_Thread_stop0_stub ),
  MAPPING( Java_java_lang_Thread_suspend0_stub ),
  MAPPING( Java_java_lang_Thread_resume0_stub ),
  MAPPING( Java_java_lang_Thread_interrupt0_stub ),
  /* JDK1.2 */
  MAPPING( Java_java_lang_Thread_registerNatives_stub ),

  MAPPING( Java_java_lang_Throwable_printStackTrace0_stub ),
  MAPPING( Java_java_lang_Throwable_fillInStackTrace_stub ),

#if notyet
  MAPPING( Java_java_lang_UNIXProcess_destroy_stub ),
  MAPPING( Java_java_lang_UNIXProcess_forkAndExec_stub ),
  MAPPING( Java_java_lang_UNIXProcess_initLockObject_stub ),
  MAPPING( Java_java_lang_UNIXProcess_run_stub ),
  /* JDK1.1 */
  MAPPING( Java_java_lang_UNIXProcess_notifyReaders_stub ),
#endif
};

int num_java_lang_mappings = sizeof(java_lang_mappings) / sizeof(java_lang_mappings[0]);

#endif
