/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"

#include "dynamic_loading.h"
#if !defined(HAVE_LIBFFI) || !defined HAVE_DLL || defined PROFILING

#include "java_lang_reflect_Array_stubs.c"
#include "java_lang_reflect_Constructor_stubs.c"
#include "java_lang_reflect_Field_stubs.c"
#include "java_lang_reflect_Method_stubs.c"

sym_mapping java_lang_reflect_mappings[] = {
  MAPPING( Java_java_lang_reflect_Array_getLength_stub ),
  MAPPING( Java_java_lang_reflect_Array_get_stub ),
  MAPPING( Java_java_lang_reflect_Array_getBoolean_stub ),
  MAPPING( Java_java_lang_reflect_Array_getByte_stub ),
  MAPPING( Java_java_lang_reflect_Array_getChar_stub ),
  MAPPING( Java_java_lang_reflect_Array_getShort_stub ),
  MAPPING( Java_java_lang_reflect_Array_getInt_stub ),
  MAPPING( Java_java_lang_reflect_Array_getLong_stub ),
  MAPPING( Java_java_lang_reflect_Array_getFloat_stub ),
  MAPPING( Java_java_lang_reflect_Array_getDouble_stub ),
  MAPPING( Java_java_lang_reflect_Array_set_stub ),
  MAPPING( Java_java_lang_reflect_Array_setBoolean_stub ),
  MAPPING( Java_java_lang_reflect_Array_setByte_stub ),
  MAPPING( Java_java_lang_reflect_Array_setChar_stub ),
  MAPPING( Java_java_lang_reflect_Array_setShort_stub ),
  MAPPING( Java_java_lang_reflect_Array_setInt_stub ),
  MAPPING( Java_java_lang_reflect_Array_setLong_stub ),
  MAPPING( Java_java_lang_reflect_Array_setFloat_stub ),
  MAPPING( Java_java_lang_reflect_Array_setDouble_stub ),
  MAPPING( Java_java_lang_reflect_Array_newArray_stub ),
  MAPPING( Java_java_lang_reflect_Array_multiNewArray_stub ),
#ifdef JDK_11
  MAPPING( Java_java_lang_reflect_Constructor_getModifiers_stub ),
#endif
  MAPPING( Java_java_lang_reflect_Constructor_newInstance_stub ),
#ifdef JDK_11
  MAPPING( Java_java_lang_reflect_Field_getModifiers_stub ),
#endif
  MAPPING( Java_java_lang_reflect_Field_get_stub ),
  MAPPING( Java_java_lang_reflect_Field_getBoolean_stub ),
  MAPPING( Java_java_lang_reflect_Field_getByte_stub ),
  MAPPING( Java_java_lang_reflect_Field_getChar_stub ),
  MAPPING( Java_java_lang_reflect_Field_getShort_stub ),
  MAPPING( Java_java_lang_reflect_Field_getInt_stub ),
  MAPPING( Java_java_lang_reflect_Field_getLong_stub ),
  MAPPING( Java_java_lang_reflect_Field_getFloat_stub ),
  MAPPING( Java_java_lang_reflect_Field_getDouble_stub ),
  MAPPING( Java_java_lang_reflect_Field_set_stub ),
  MAPPING( Java_java_lang_reflect_Field_setBoolean_stub ),
  MAPPING( Java_java_lang_reflect_Field_setByte_stub ),
  MAPPING( Java_java_lang_reflect_Field_setChar_stub ),
  MAPPING( Java_java_lang_reflect_Field_setShort_stub ),
  MAPPING( Java_java_lang_reflect_Field_setInt_stub ),
  MAPPING( Java_java_lang_reflect_Field_setLong_stub ),
  MAPPING( Java_java_lang_reflect_Field_setFloat_stub ),
  MAPPING( Java_java_lang_reflect_Field_setDouble_stub ),
#ifdef JDK_11
  MAPPING( Java_java_lang_reflect_Method_getModifiers_stub ),
#endif
  MAPPING( Java_java_lang_reflect_Method_invoke_stub )
};

int num_java_lang_reflect_mappings = sizeof(java_lang_reflect_mappings) / sizeof(java_lang_reflect_mappings[0]);
#endif
