/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"

#include "dynamic_loading.h"

#if !defined(HAVE_LIBFFI) || !defined HAVE_DLL || defined PROFILING
#include "java_io_FileDescriptor_stubs.c"
#include "java_io_FileInputStream_stubs.c"
#include "java_io_FileOutputStream_stubs.c"
#include "java_io_RandomAccessFile_stubs.c"
#include "java_io_ObjectStreamClass_stubs.c"
#include "java_io_ObjectInputStream_stubs.c"
#include "java_io_ObjectOutputStream_stubs.c"
#include "java_io_File_stubs.c"

/* JDK1.2 */
#include "java_io_FileSystem_stubs.c"
#ifdef _WINDOWS
#include "java_io_Win32FileSystem_stubs.c"
#else
#include "java_io_UnixFileSystem_stubs.c"
#endif

sym_mapping java_io_mappings[] = {
  MAPPING( Java_java_io_FileDescriptor_sync_stub ),
#if notyet
  /* JDK1.1 */
  MAPPING( Java_java_io_FileDescriptor_valid_stub ),
  MAPPING( Java_java_io_FileDescriptor_initSystemFD_stub ),
#endif

  MAPPING( Java_java_io_FileInputStream_open_stub ),
  MAPPING( Java_java_io_FileInputStream_read_stub ),
  MAPPING( Java_java_io_FileInputStream_readBytes_stub ),
  MAPPING( Java_java_io_FileInputStream_skip_stub ),
  MAPPING( Java_java_io_FileInputStream_available_stub ),
  MAPPING( Java_java_io_FileInputStream_close_stub ),
  
  MAPPING( Java_java_io_FileOutputStream_open_stub ),
  MAPPING( Java_java_io_FileOutputStream_openAppend_stub ),
  MAPPING( Java_java_io_FileOutputStream_write_stub ),
  MAPPING( Java_java_io_FileOutputStream_writeBytes_stub ),
  MAPPING( Java_java_io_FileOutputStream_close_stub ),
  
#if notyet
  /* JDK1.1 */
  MAPPING( Java_java_io_File_exists0_stub ),
  MAPPING( Java_java_io_File_canWrite0_stub ),
  MAPPING( Java_java_io_File_canRead0_stub ),
  MAPPING( Java_java_io_File_isFile0_stub ),
  MAPPING( Java_java_io_File_isDirectory0_stub ),
  MAPPING( Java_java_io_File_lastModified0_stub ),
  MAPPING( Java_java_io_File_length0_stub ),
  MAPPING( Java_java_io_File_mkdir0_stub ),
  MAPPING( Java_java_io_File_renameTo0_stub ),
  MAPPING( Java_java_io_File_delete0_stub ),
  MAPPING( Java_java_io_File_rmdir0_stub ),
  MAPPING( Java_java_io_File_list0_stub ),
  MAPPING( Java_java_io_File_canonPath_stub ),
  MAPPING( Java_java_io_File_isAbsolute_stub ),
#endif

  MAPPING( Java_java_io_FileSystem_getFileSystem_stub ),

  MAPPING( Java_java_io_RandomAccessFile_open_stub ),
  MAPPING( Java_java_io_RandomAccessFile_read_stub ),
  MAPPING( Java_java_io_RandomAccessFile_readBytes_stub ),
  MAPPING( Java_java_io_RandomAccessFile_write_stub ),
  MAPPING( Java_java_io_RandomAccessFile_writeBytes_stub ),
  MAPPING( Java_java_io_RandomAccessFile_getFilePointer_stub ),
  MAPPING( Java_java_io_RandomAccessFile_seek_stub ),
  MAPPING( Java_java_io_RandomAccessFile_length_stub ),
  MAPPING( Java_java_io_RandomAccessFile_close_stub ),

#if notyet
  /* JDK1.1 */
  MAPPING( Java_java_io_ObjectStreamClass_getClassAccess_stub ),
  MAPPING( Java_java_io_ObjectStreamClass_getMethodSignatures_stub ),
  MAPPING( Java_java_io_ObjectStreamClass_getMethodAccess_stub ),
  MAPPING( Java_java_io_ObjectStreamClass_getFieldSignatures_stub ),
  MAPPING( Java_java_io_ObjectStreamClass_getFieldAccess_stub ),
  MAPPING( Java_java_io_ObjectStreamClass_getFields0_stub ),
  MAPPING( Java_java_io_ObjectStreamClass_getSerialVersionUID_stub ),
  MAPPING( Java_java_io_ObjectStreamClass_hasWriteObject_stub ),
#endif

  MAPPING( Java_java_io_ObjectInputStream_loadClass0_stub ),
#if notyet
  /* JDK1.1 */
  MAPPING( Java_java_io_ObjectInputStream_inputClassFields_stub ),
  MAPPING( Java_java_io_ObjectInputStream_invokeObjectReader_stub ),
#endif
  MAPPING( Java_java_io_ObjectInputStream_allocateNewObject_stub ),
  MAPPING( Java_java_io_ObjectInputStream_allocateNewArray_stub ),

#if notyet
  /* JDK1.1 */
  MAPPING( Java_java_io_ObjectOutputStream_outputClassFields_stub ),
  MAPPING( Java_java_io_ObjectOutputStream_invokeObjectWriter_stub ),
#endif
  
#ifdef _WINDOWS
  MAPPING( Java_java_io_Win32FileSystem_canonicalize_stub ),
  MAPPING( Java_java_io_Win32FileSystem_canonicalize_stub ),
  MAPPING( Java_java_io_Win32FileSystem_checkAccess_stub ),
  MAPPING( Java_java_io_Win32FileSystem_createDirectory_stub ),
  MAPPING( Java_java_io_Win32FileSystem_createFileExclusively_stub ),
  MAPPING( Java_java_io_Win32FileSystem_delete_stub ),
  MAPPING( Java_java_io_Win32FileSystem_deleteOnExit_stub ),
  MAPPING( Java_java_io_Win32FileSystem_getBooleanAttributes_stub ),
  MAPPING( Java_java_io_Win32FileSystem_getDriveLetter_stub ),
  MAPPING( Java_java_io_Win32FileSystem_getLastModifiedTime_stub ),
  MAPPING( Java_java_io_Win32FileSystem_getLength_stub ),
  MAPPING( Java_java_io_Win32FileSystem_initIDs_stub ),
  MAPPING( Java_java_io_Win32FileSystem_list_stub ),
  MAPPING( Java_java_io_Win32FileSystem_listRoots0_stub ),
  MAPPING( Java_java_io_Win32FileSystem_rename_stub ),
  MAPPING( Java_java_io_Win32FileSystem_setLastModifiedTime_stub ),
  MAPPING( Java_java_io_Win32FileSystem_setReadOnly_stub )
#else
#endif
};

int num_java_io_mappings = sizeof(java_io_mappings) / sizeof(java_io_mappings[0]);

#endif
