/* -*- Mode: C; c-file-style: "gnu" -*-
   filesystem.c -- native methods pertaining to java.io.FileSystem
   Created: Chris Toshok <toshok@hungry.com>, 11-Nov-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jni.h"
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

/* don't forget about mac here. */
#ifdef _WINDOWS
#define FILESYSTEM_CLASS "java/io/Win32FileSystem"
#else
#define FILESYSTEM_CLASS "java/io/UnixFileSystem"
#endif

/* JDK 1.2 */
JNIEXPORT jobject JNICALL
Java_java_io_FileSystem_getFileSystem(JNIEnv *env,
				      jclass fs_cls)
{
  jclass cls = (*env)->FindClass(env, FILESYSTEM_CLASS);
  jmethodID init = (*env)->GetMethodID(env, cls, "<init>", "()V");
  jobject fs;

  if ((*env)->ExceptionOccurred(env))
    {
      (*env)->ExceptionDescribe(env);
    }

  fs = (*env)->NewObject(env, cls, init);

  if ((*env)->ExceptionOccurred(env))
    {
      (*env)->ExceptionDescribe(env);
    }

  return fs;
}
