/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DYNAMIC_LOADING_H
#define DYNAMIC_LOADING_H

#include "config.h"

#ifdef __cplusplus
extern "C" {
#endif

#if defined USE_DLL && ( defined HAVE_DLFCN_H || defined HAVE_DL_H )
#  if (__FreeBSD__ < 3  && !defined( PROFILING )) || !defined(__FreeBSD__)
#   define HAVE_DLL
#  endif
#endif

  typedef struct {
    char *name;
    void *func_ptr;
  } sym_mapping;

#define MAPPING( name ) { #name , (void*)name }

#if defined HAVE_DLL && !defined PROFILING
  typedef void *DLL_LibHandle;
#else
  typedef struct DLL_LibHandle 
  {
    sym_mapping *mappings;
    int num_mappings;
  } *DLL_LibHandle;
#endif
  typedef void* DLL_FuncHandle;

  /* Load a shared object.  lib_path is presumed to be the full
     path name, including the extender. */
  DLL_LibHandle 	DLL_load(char *lib_path);

  /* Finds and loads a shared object.  The lookup strategy is
     architecture defined (unix platforms will probably use
     LD_LIBRARY_PATH).  lib_name is only the library name.  It
     does not include the extender or the path. */
  DLL_LibHandle	DLL_find(char *lib_name);

  /* Unloads a library. */
  void 		DLL_unload(DLL_LibHandle handle);

  /* attempts to find a function in a specific library */
  DLL_FuncHandle DLL_findFunctionInLib(char *func_name,
				       DLL_LibHandle handle);

  /* Find a function in any of the shared objects loaded in
     as well in the executable. */
  DLL_FuncHandle 	DLL_findFunction(char *func_name);

  /* Map from a japhar library name to a platform specific filename.
     e.g. lib_name = "zip" => libjaphar_zip.so (on freebsd)
  */
  char *DLL_mapLibName(char *lib_name);

#ifdef __cplusplus
};
#endif

#endif /* DYNAMIC_LOADING_H */
