/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "native-threads.h"
#include "exceptions.h"
#include "log.h"

#include <stdio.h>
#include <stdlib.h>

/* XXX Dummy method to avoid linking with libruntime */
void LOG_log(char *log, int level, char *msg_format, ...) {}
void throw_Exception(JNIEnv *env, const char *name,const char *msg) {}

/* This test must match the one on dynamic_loading.c */
#if (!defined(HAVE_DLL)) || defined PROFILING
int sysres_mappings = 0;
int java_util_mappings = 0;
int java_util_zip_mappings = 0;
int java_lang_mappings = 0;
int num_java_util_mappings = 0;
int num_java_lang_mappings = 0;
int num_java_net_mappings = 0;
int java_io_mappings = 0;
int java_net_mappings = 0;
int num_java_util_zip_mappings = 0;
int num_sysres_mappings = 0;
int num_java_io_mappings = 0;
#endif

static HMonitor monitor;

static void*
thread_func(void* arg)
{
  int i = 0;
  char *name = (char*)arg;

  while (++i)
    {
      MONITOR_enter(monitor);
      printf ("%s : %d\n", name, i);
      MONITOR_exit(monitor);
    }

  /* NOTREACHED */
  return NULL;
}

static void*
idle_func(void* arg)
{
  while (1) ;

  /* NOTREACHED */
  return NULL;
}

int
main(int argc,
     char **argv)
{
  monitor = MONITOR_create();

  THREAD_start(thread_func, "hello", 0, 0);
  THREAD_start(thread_func, "goodbye", 0, 0);

  idle_func(NULL);

  /* NOTREACHED */
  return 0;
}
