#ifndef _ZIP_H
#define _ZIP_H

/*
** $Id: zip.h,v 1.4 2001/08/31 22:06:54 buytaert Exp $
*/

#include "jamjar.h"

/*
** Magic constants used by zip.
*/

#define Z_LOCAL_SIG                     0x04034b50
#define Z_DIR_SIG                       0x02014b50
#define Z_DIGITAL_SIG                   0x05054b50
#define Z_DIR_END_SIG                   0x06054b50

#define Z_UNIX_MADE                     0x0003

#define ID_JAMJAR                       0x7856 // Or own jamjar ID for the extra data
#define ID_INFO_ZIP                     0x7855 // Unix Info Zip ID

#define ZIP_VERSION                     0x0014 // Version needed to extract and that was used to compress
#define ZIP_FLAGS                       0x0002 // Maximum compression was used
#define ZIP_DEFLATE                     0x0008 // Deflate method was used
#define ZIP_STORE                       0x0000 // For store only

typedef struct j_Entry {
  j_entry next;
  j_entry previous;
  j_zip zip;                            // The zip file this entry belongs to
  j_res res;                            // The resource associated with the entry
} j_Entry;

typedef struct j_Zip {
  j_arg arg;                            // The argument that describes this zip/jarfile
  size_t num_entries;                   // The number of entries
  j_entry entries;                      // The list of entries in the zip/jarfile
  j_res manifest;                       // The resource of the MANIFEST.MF file. It will not be put in the hashtable
  j_res index;                          // The resource of the INDEX.LIST file
} j_Zip;

j_zip zip_read(j_arg arg, int mode);
size_t res_write_local(j_res res);
size_t res_write_central(j_res res);
void zip_write_trailer(j_out out);
int zip_is_compressed(j_byte * stream);

#endif /* _ZIP_H */
