/**************************************************************************
* Copyright  (c) 2001 by Acunia N.V. All rights reserved.                 *
*                                                                         *
* This software is copyrighted by and is the sole property of Acunia N.V. *
* and its licensors, if any. All rights, title, ownership, or other       *
* interests in the software remain the property of Acunia N.V. and its    *
* licensors, if any.                                                      *
*                                                                         *
* This software may only be used in accordance with the corresponding     *
* license agreement. Any unauthorized use, duplication, transmission,     *
*  distribution or disclosure of this software is expressly forbidden.    *
*                                                                         *
* This Copyright notice may not be removed or modified without prior      *
* written consent of Acunia N.V.                                          *
*                                                                         *
* Acunia N.V. reserves the right to modify this software without notice.  *
*                                                                         *
*   Acunia N.V.                                                           *
*   Vanden Tymplestraat 35      info@acunia.com                           *
*   3000 Leuven                 http://www.acunia.com                     *
*   Belgium - EUROPE                                                      *
**************************************************************************/

/*
** $Id: meta.c,v 1.8 2002/08/13 16:15:13 dbuytaert Exp $
**
** Routines to create manifest and index files.
*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h> 
#include <zlib.h>
#include <time.h>
#include <string.h>

#include "meta.h"
#include "resource.h"
#include "argument.h"
#include "zip.h"

j_res manifest_create(j_zip zip) {

  int bufsize = 1024;
  char * buffer = NULL;
  j_res res = jj_calloc(1, sizeof(j_Res));
  int fd;
  time_t t = 0;
  int use_existing = 0;

  if (options->manifest) {
    bufsize = options->manifest->size;
    buffer = jj_calloc(bufsize, sizeof(char));
    fd = open(options->manifest->file, O_RDONLY);
    if (fd == -1) {
      logmsg(0, "could not open manifest file '%s'\n", options->manifest->file);
    }
    read(fd, buffer, bufsize);
    close(fd);
    t = options->manifest->time;
    logmsg(2, "read in manifest file '%s'.\n", options->manifest->file);
  }
  else if (zip && zip->manifest) {
    use_existing = 1;
    res = zip->manifest;
    res_hash(res);
    logmsg(2, "re-using existing manifest file\n");
  }
  else {
    buffer = jj_calloc(bufsize, sizeof(char));
    sprintf(buffer + strlen(buffer), "Manifest-Version: 1.0\n");
    sprintf(buffer + strlen(buffer), "Created-By: (Wonka's jamjar %s)\n", options->version);
    sprintf(buffer + strlen(buffer), "\n");
    buffer = jj_realloc(buffer, strlen(buffer)+1);
    t = time(NULL);
    logmsg(2, "created new manifest file\n");
  }

  /*
  ** Prepare everything so that the MANIFEST.MF file will only
  ** be stored and not compressed.
  */

  if (! use_existing) {
    res->time = t;
    res->u_data = buffer;
    res->u_size = strlen(buffer);
    res->c_data = buffer;
    res->c_size = res->u_size;
    res->z_name = jj_calloc(21, sizeof(char));
    strcpy(res->z_name, "META-INF/MANIFEST.MF");
    res->crc = crc32(0, Z_NULL, 0);
    res->crc = crc32(res->crc, res->u_data, res->u_size);
    res_hash(res);
  }

  /*
  ** In any case, the manifest file should be written to the output jar.
  */
  
  setFlag(res->flags, RES_WRITE);

  return res;

}
