#include "isectd.h"
#include <errno.h>

/*
   the goal in this routine was to have all messages sent to workers
   from clients to go through one routine, so we can keep track of
   the messages and be sure everything is properly cleaned-up
   later.

   the client has already been assigned to the worker, so he can
   get the message from there.
 */

int 
isdToWorker(isdWorker * worker)
{
	isdClient *client;
	int bytes = 0, saverr;

	if (client = worker->client)
		if (client->ready) { 
			worker->header = client->header;
			isdLogEvent("from client x%p, to worker x%p, len=%d, seq=%d, more=%d", client, worker,
						client->header.len, client->header.sequence, client->header.more);
			bytes = isdSend(worker->socket, client->msgBuffer, client->header.len, &client->header);

			worker->msgBuffer = client->msgBuffer;
			client->msgBuffer = NULL;

			if (bytes != client->header.len) {
				saverr = errno;
				isdLog("***only wrote %d of %d bytes***\n", bytes, client->header.len);
				isdLog((char *) strerror(saverr));
			}
			worker->toCount++;
			client->ready = 0;

			if (!FD_ISSET(client->socket, &isdData.allfds))
				FD_SET(client->socket, &isdData.allfds);
			if (!FD_ISSET(worker->socket, &isdData.writefds))
				FD_SET(worker->socket, &isdData.writefds);
		}

	return bytes;
}
