/*
05/17/2000	hostname can now be in the form host:port for connecting
			to ports other than the default port.  Useful for chaining
			isectds together via link workers.

			if hostname:port is specified, the service parameter is ignored.
			this basically works because clients login using
			isdAttach("isectd", "op", NULL, 2) which gets translated into
			a call isdConnectTo("isectd","isectd") which isn't what would
			be wanted.  Instead, if "anotherhost:9292" were desired then
			the call would resemble isdConnectTo("anotherhost:9292","isectd")
			which isn't what would be intended.  Instead, this routine will
			use 9292 for a port number if supplied.
*/

#include "isdio.h"
#include <memory.h>

SOCKET Xport 
isdConnectTo(const char *hostname, const char *service)
{
	int port, err = INVALID_SOCKET;
	SOCKET sock;
	struct hostent *hostent;
	struct servent *servent;
	struct sockaddr_in server;
	char *endptr, *alternatePort, *myHost;

#ifdef _Windows
	WSADATA asadata;

	WSAStartup((WORD) 0x20, &asadata);
#endif

	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) != INVALID_SOCKET) {
		isdSockOpts(sock);

		memset((void *) &server, 0, sizeof server);

		myHost = strdup(hostname);
		if (alternatePort = strchr(myHost, ':'))
			*alternatePort++ = 0;

		if (hostent = gethostbyname(myHost)) {
			server.sin_family = AF_INET;
			memmove((char *) &server.sin_addr, (char *) hostent->h_addr, hostent->h_length);

			if (alternatePort) 
				service = alternatePort;
			
			port = strtol(service, &endptr, 0);
			if (endptr != service)
				server.sin_port = htons(port);
			else {
				if (servent = getservbyname(service, 0))
					server.sin_port = servent->s_port;
			}
			if (server.sin_port) 
				if (connect(sock, (struct sockaddr *) &server, sizeof server) != -1) 
					err = 0;
		}
		free(myHost);
	}

	if (err != 0)
		isdLogout(sock);

	return err == 0 ? sock : err;
}
