#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include "libisect.h"
#include "rmt.h"

int 
rmtdo(SOCKET sock, char *command)
{
	int err = 0, argc;
	char *cp, *tp, *argv[MAXARGS];
	char reply[64], arg[MAXARGS][128];
	static char mycommand[1024], buffer[1024];
	struct ReplyTo *replyto;

	for (argc = 0; argc < MAXARGS; argc++)
		argv[argc] = arg[argc];

	mycommand[0] = 0;
	for (tp = strtok(command, "\n"); tp && *tp == '!'; tp = strtok((char *) NULL, "\n")) {
		sprintf(buffer, "%s\n", tp);
		strcat(mycommand, buffer);
	}

	if (tp == NULL)
		tp = command;

	argc = sscanf(tp, "%s%s%s%s%s%s%s%s%s%s", arg[0], arg[1], arg[2], arg[3], arg[4], arg[5], arg[6], arg[7], arg[8], arg[9]);
	argv[argc] = 0;

	strcpy(reply, "");

#ifdef _Windows
	isdLog("%s\n", command);
	if (WinExec(command, SW_SHOW) <= 31)
		perror(command);
#else
	if (strcmp(strupr(argv[0]), "RUN") == 0) {
		replyto = NULL;
		cp = &tp[4];
		if (argv[1][0] == '@') {
			replyto = (struct ReplyTo *) calloc(1, sizeof *replyto);
			strcpy(replyto->portname, &argv[1][1]);
			for (cp = strchr(&tp[4], '=') + 1; isspace(*cp); cp++);
		}
		strcat(mycommand, cp);
		sprintf(reply, "%d", err = rmtchild(mycommand));
		if (replyto) {
			if ((replyto->pid = err) == -1)
				free(replyto);
			else
				InsertTail(&ReplyToQueue, (Node *) replyto);
		}
	}

	else if (strcmp(argv[0], "KILL") == 0) {
		sprintf(reply, "%d", err = rmtkill(command));
	}

	else if (strcmp(argv[0], "RENICE") == 0) {
		strcpy(reply, rmtrenice(command));
	}

	else
		err = rmtchild(command);
#endif

	if (*reply)
		send(sock, reply, strlen(reply) + 1, 0);
	return err;
}
