#!/bin/sh
############################
# Author   $Author: rudi $
# Date     $Date: 1999/08/23 14:06:46 $
# cvsid = "$Header: /u/cvs/isect/demo/test.sh,v 1.2 1999/08/23 14:06:46 rudi Exp $"
# Revision $Revision: 1.2 $
############################
# Tool to test isect using isdclient.
# You should start a number of echo services before you run this script.
#
############################
# Log      $Log: test.sh,v $
# Log      Revision 1.2  1999/08/23 14:06:46  rudi
# Log      New test scripts
# Log                                                   
#
############################

DEF_TRANS=20
DEF_HOST="127.0.0.1"
prog_name=$0

Usage() {
  echo "This a testing script for the isect system"
  echo "Please run ${prog_name} as follows"
  echo "  ${prog_name}"
  echo "  ${prog_name} num_transactions"
  echo "  ${prog_name} num_transactions host_isect"
  echo
  echo "eg. ${prog_name} 20"
  echo "    ${prog_name} 20 127.0.0.1"
  echo 
  echo "Defaults are:"
  echo "       num_clients=${DEF_CLIENTS}"
  echo "        host_isect=${DEF_HOST}"
  echo
  exit
}


case $# in
  0)
    num_transactions=${DEF_CLIENTS}
    isect_host=${DEF_HOST}
    ;;
  1)
    num_transactions=$1
    isect_host=${DEF_HOST}
    ;;
  2)
    num_transactions=$1 
    isect_host=$2
    ;;
  *)
    Usage
    ;;
esac

cnt=0

while test ${cnt} -ne ${num_transactions}
do
  text="test${cnt}"
  rettext=`isdclient -h ${isect_host} -c "${text}" echo`
  retval=$? 
  if [ "${rettext}" != "${text}" ]; then
    echo "Failed the echo test on cnt=${cnt} from pid=$$ retval=${retval} - output was ${rettext}"
    exit 1
  fi
  cnt=`expr ${cnt} + 1`
done

echo "$0 with pid $$ completed successfully."
