;;;;;;;;; -*- Emacs-Lisp -*- ;;;;;;;;;

;;
;; irchat-pj.emacs
;; initial setting file for irchat-pj
;; Wed, 27 Jan 1999, by simm@irc.fan.gr.jp and irchat-PJ Project
;; last modified by simm@irc.fan.gr.jp, Mon, 08 Nov 1999 03:35:53 +0900
;;

;; auto-load
(autoload 'irchat "irchat" "IRC client for Emacsen." t)

;;; ----------------------------------------------------------------
;;; irchat $(B0lHL@_Dj(B
;;; ----------------------------------------------------------------

;;; $(B=q$-49$($,I,MW$JItJ,(B : server, nick, name
;;(setq irchat-server "irc.karrn.ad.jp")
;;(setq irchat-name "Hoge of Hoge!?")
;;(setq irchat-nickname "hogehoge")
;;(setq irchat-pj-startup-nickname-list '("hogehoge" "fugafuga" "fugahoge" "uhiaha"))
(setq irchat-server "irc.friend.td.nu")
(setq irchat-name (or (user-full-name) "nil"))
(setq irchat-nickname (or (user-real-login-name) "nonick"))

;; default $(B$G;22C$9$k(B channel $(B$N(B list
;; ($(B$3$3$K=q$$$?(B channel $(B$K$O(B irchat $(B$N5/F0$HF1;~$K;22C$G$-$^$9(B)
(setq irchat-startup-channel-list '("#$(B$A$c$M$k(B1" "#$(B$A$c$M$k(B2"))

;; C-($(B?t;z(B)$(B$N(B key-bind $(B$N7hDj(B. $(B:G=i$+$i=g$K(B,
;;   C-1, C-2, ..., C-9, C-c C-c 0, C-c C-c 1, ..., C-c C-c 9,
;;   C-c C-d 0, C-c C-d 1, ..., C-c C-d 9
;; $(B$H$J$j$^$9(B.
(setq irchat-default-channel-binding
      '("#$(B$A$c$M$k(B1" "#$(B$A$c$M$k(B2" "#$(B$A$c$M$k(B3" nil "#$(B$A$c$M$k(B5"))

;;; ----------------------------------------------------------------
;;; $(B3F<o$3$^$+$$8D?M@_Dj(B
;;; ----------------------------------------------------------------

;; nick $(B$*$h$S(B channel $(B$NBP>]HO0O(B
;; t  : $(B%5!<%P$K@\B3$7$F$$$kA4%f!<%6$N(B nick $(B$*$h$S(B $(BB8:_$9$kA4(B channel
;; nil: $(B<+J,<+?H$,8+$($kHO0O$G$N(B nick $(B$*$h$S(B channel
(setq irchat-global-names nil)
;; $(B@ZCG$5$l$?$H$-<+F0@\B3$9$k$+$I$&$+(B
(setq irchat-reconnect-automagic t)
;; channel $(B$4$H$K(B buffer $(B$r:n@.$9$k$+$I$&$+(B
(setq irchat-channel-buffer-mode t)
;; channel $(B$4$H$N(B buffer $(B$K$D$$$F(B, $(B3FH/8@$4$H$K(B channel $(BL>$rI=<($9$k$+$I$&$+(B
;; t  : <#$(B$A$c$M$k(B:nick> $(B$,$,!D(B
;; nil: <nick> $(B$,$,!D(B
(setq irchat-display-channel-always t)
;; channel buffer $(B$r<+F0E*$K%9%/%m!<%k$5$;$J$$$+$I$&$+(B
;; t: $(B$5$;$J$$(B, nil: $(B$5$;$k(B
(setq irchat-default-freeze-local nil)
;; \007 $(B$N%3!<%I$r<u$1<h$C$?$H$-$K(B beep $(B$rLD$i$9$+$I$&$+(B
(setq irchat-beep-on-bells t)
;; quit $(B$9$k$H$-$N%a%C%;!<%8(B
(setq irchat-signoff-msg "Good night.")

;;; ----------------------------------------------------------------
;;; irchat-pj $(BFH<+$N@_Dj(B
;;; ----------------------------------------------------------------

;; coding-system $(B$N;XDj(B. $(BF~NO$OF|K\8l<+F0H=JL(B, $(B=PNO$O(B iso-2022-7bit-ss2
(setq irchat-pj-string-in-code  'auto-detect
      irchat-pj-string-out-code 'iso-2022-7bit-ss2)
;; $(B=PNO;~$K(B, $(B$$$o$f$kH>3Q%+%J$rA43Q%+%J$KJQ49(B ($(BF~NO;~$O$=$N$^$^(B)
(setq irchat-pj-katakana-convert t)
;; SJIS$(B$dF|K\8l(BEUC$(B%3!<%I$r<u$1<h$C$?$H$-$K(B, minibuffer $(B$K$=$N;]I=<($9$k$+$I$&$+(B
(setq irchat-pj-code-verbose nil)

;; invite $(B$5$l$?$H$-$K2;$rLD$i$9$+$I$&$+(B
(setq irchat-pj-sound-when-invited t)

;; buffer $(B$r$D$/$C$F$$$J$$(B nick $(B$N?M$+$i8D?M08$X$N(B private message $(B$r(B
;; $(B<u$1<h$C$?$H$-$K2;$rLD$i$9$+$I$&$+(B
(setq irchat-pj-sound-when-private t)

;; $(BC/$+$,(B join $(B$7$F$-$?$H$-$K2;$rLD$i$9$+$I$&$+(B
(setq irchat-pj-sound-when-join t)

;; CTCP message $(B$r<u$1<h$C$?$H$-$K2;$rLD$i$9$+$I$&$+(B
(setq irchat-pj-sound-when-ctcp t)

;; $(B2;$rLD$i$9%-!<%o!<%I$N@_Dj(B. $(B@55,I=8=$b2D(B
;; $(B$3$NJQ?t$,(B nil $(B$N>l9g$O(B, $(BFCDj$N%-!<%o!<%I$KH?1~$7$F2;$OLD$i$J$$(B
(setq irchat-pj-sound-words-alist '("$(B$,$,(B" "$(B$[$2(B" "irc.*[Pp]"))

;; $(B%5%&%s%I%U%!%$%k$rCV$/%G%#%l%/%H%j$N@_Dj(B
(setq irchat-pj-sound-directory "~/lib/au")

;; $(B%5%&%s%I%U%!%$%k$N@_Dj(B
(setq irchat-pj-sound-words-file   "foo.au")
(setq irchat-pj-sound-invited-file "bar.au")
(setq irchat-pj-sound-private-file "baz.au")
(setq irchat-pj-sound-join-file    "baz.au")
(setq irchat-pj-sound-ctcp-file    "bar.au")

;; .au $(B%U%!%$%k$N:F@8%W%m%0%i%`$N@_Dj(B
(setq irchat-pj-sound-au-player "xplay")

;; .wav $(B%U%!%$%k$N:F@8%W%m%0%i%`$N@_Dj(B
(setq irchat-pj-sound-wav-player "xplay")

;; private message $(B$b$7$/$O(B notice $(B7A<0$G(B server $(B$+$i$N(B message $(B$r(B
;; $(B<u$1<h$C$?$H$-(B, $(B=q$-49$($r9T$&$+$I$&$+(B
(setq irchat-pj-rewrite-server-notice t)

;; $(B%A%c%M%k$KBP$7$F(B broadcast $(B$O9T$&$,(B, priv$(BAj<j$K$O9T$o$J$$(B
(setq irchat-pj-broadcast-channel t
      irchat-pj-broadcast-private nil)

;; $(B%9%/%m!<%k$N5sF0(B: $(BJL%U%l!<%`$,(Bactive$(B$J>l9g$G$b%9%/%m!<%k$9$k(B
(setq irchat-pj-scroll-condition t)

;; $(B3F(B buffer $(B$N(B mode-line $(B$r;XDj(B
(setq irchat-pj-Commands-mode-line-format 'irchat-pj-Commands-mode-line-format-minor-mode
      irchat-pj-Dialogue-mode-line-format 'irchat-pj-Dialogue-mode-line-format-minor-mode
      irchat-pj-Other-mode-line-format    'irchat-pj-Other-mode-line-format-minor-mode
      irchat-pj-Channel-mode-line-format  'irchat-pj-Channel-mode-line-format-minor-mode)

;; $(B<+F0E*$K(B channel oper $(B$rG[$k@_Dj(B
(setq irchat-pj-auto-oper-list
      '(; $(BA4%A%c%M%k$K$*$$$F(B *!*simm*@*.fan.gr.jp $(B$K(Bmatch $(B$9$k?M$KG[$k(B
	".*!.*simm.*@.*\\.fan\\.gr\\.jp"
	; #$(B$A$c$M$k(B1 $(B$*$h$S(B #$(B$A$c$M$k(B2 $(B$K$*$$$F(B, *!*hoge*@*.hoge.ne.jp $(B$K(B match $(B$9$k?M$KG[$k(B
	(".*!.*hoge.*@.*\\.hoge\\.ne\\.jp" "#$(B$A$c$M$k(B1" "#$(B$A$c$M$k(B2")))

;; irchat-pj $(B=*N;;~$K%P%C%U%!:o=|(B
(setq irchat-pj-quit-with-kill-buffer t)

;;
;; end
;;
