/*-
 * Copyright (c) 2003 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *  @(#)$Id: confcommon.h,v 1.2 2011/01/23 18:42:34 simon Exp $
 */

#ifndef IPA_CONFCOMMON_H
#define IPA_CONFCOMMON_H

#ifndef SYM_PREFIX
# if defined (__GNUC__) && !defined(__ELF__)
#  define SYM_PREFIX "_"
# endif
#endif

/* Validate whether empty TAILQ_HEAD is in consistent state. */
#define TAILQ_EMPTY_HEAD_VALID(x) \
	((x)->tqh_first == NULL && (x)->tqh_last == &(x)->tqh_first)

/* Validate whether empty STAILQ_HEAD is in consistent state. */
#define STAILQ_EMPTY_HEAD_VALID(x) \
	((x)->stqh_first == NULL && (x)->stqh_last == &(x)->stqh_first)

/*
 * This structure determines parser for some argument
 * of IPA_CONF_TYPE_xxx type.
 */
struct get_arg {
	void		*argp;		/* Pointer to the result. */
	int		(*parse)(void *); /* Parser. */
	regex_t		*reg;		/* Optional regular expression. */
};

#ifndef CONF_SECT_BUCKETS
# define CONF_SECT_BUCKETS	16	/* Must be power of 2. */
#endif

struct conf_sect_he {
	SLIST_ENTRY(conf_sect_he) link;	/* For list building. */
	unsigned int	hash_value;	/* Hashed value of sect_name. */
	const char	*sect_name;	/* Section name. */
	unsigned int	idx;		/* Section descriptor index. */
};

SLIST_HEAD(conf_sect_hash, conf_sect_he);

#ifndef CONF_PARAM_BUCKETS
# define CONF_PARAM_BUCKETS	16	/* Must be power of 2. */
#endif

struct conf_param_he {
	SLIST_ENTRY(conf_param_he) link;/* For list building. */
	unsigned int	hash_value;	/* Hashed value of param_name. */
	const char	*param_name;	/* Parameter name. */
	unsigned int	idx;		/* Parameter descriptor index. */
};

SLIST_HEAD(conf_param_hash, conf_param_he);

#define CONF_SECT_HE_NSIZE	32
#define CONF_SECT_HE_NALLOC	16

#define CONF_PARAM_HE_NSIZE	64
#define CONF_PARAM_HE_NALLOC	32

#define MONTHES_IN_YEAR		12
#define HOURS_IN_DAY		24
#define DAYS_IN_WEEK		7

#define SECONDS_IN_MINUTE	60
#define MINUTES_IN_HOUR		60
#define SECONDS_IN_HOUR		(MINUTES_IN_HOUR * SECONDS_IN_MINUTE)
#define SECONDS_IN_DAY		(HOURS_IN_DAY * SECONDS_IN_HOUR)
#define SECONDS_IN_WEEK		(DAYS_IN_WEEK * SECONDS_IN_DAY)

#define KBYTE			UINT64_C(1024)
#define MBYTE			(UINT64_C(1024) * KBYTE)
#define GBYTE			(UINT64_C(1024) * MBYTE)
#define TBYTE			(UINT64_C(1024) * GBYTE)

#define PAT_TIME		"^([[:digit:]]+[smh] ?)+$"
#define PAT_BYTES		"^([[:digit:]]+[BKMGT] ?)+$"

extern const char *const conf_event_msg[];

extern int	value_units;

extern regex_t re_time;
extern regex_t re_bytes;

extern const struct get_arg get_arg_tbl[];

extern const char *curmodfile;
extern const char *curparam;
extern const char *cursect;

extern int	regexec_simple(const regex_t *, const char *);
extern const char *regerrbuf(int);

extern void	logconf(const char *, ...) ATTR_FORMAT(printf, 1, 2);
extern void	logconfx(const char *, ...) ATTR_FORMAT(printf, 1, 2);
extern void	logconfe(const char *, ...) ATTR_FORMAT(printf, 1, 2);
extern void	xlogmsgx(int, const char *, ...) ATTR_FORMAT(printf, 2, 3);

extern void	mod_logconferr(const char *, int, const char *, va_list);

extern void	mod_conf_regfree(ipa_conf_param *, ipa_conf_sect *);
extern int	mod_conf_regcomp(const char *, ipa_conf_param *,
		    ipa_conf_sect *);

extern int	strto_uint32(uint32_t *, const char *, char **);
extern int	strto_uint64(uint64_t *, const char *, char **);
extern int	strto_u_int(unsigned int *, const char *, char **);

extern int	get_arg_uint64(void *);
extern int	get_arg_time(void *);
extern int	get_arg_bytes(void *);
extern int	get_arg_value(void *);
extern int	get_arg_per_cent(void *);

extern char	got_arg_value;
extern char	need_nl;

extern const char *plural_form(unsigned int);

extern void	print_space(void);
extern void	print_time(const uint64_t *);
extern void	print_value(const uint64_t *, unsigned int);
extern void	print_boolean(int);
extern void	print_bytes(const uint64_t *);
extern void	print_string(const char *);
extern void	print_nl(void);
extern void	print_nl_cond(void);

extern void	mod_print_param_name(const char *, const char *);
extern void	mod_print_args(const char *, va_list);
extern void	mod_print_param_end(void);
extern void	mod_print_sect_name(const char *, const char *);
extern void	mod_print_sect_end(void);

extern void	print_param_name(const char *);
extern void	print_param_name0(const char *);
extern void	print_param_end(void);
extern void	print_sect_name(const char *);
extern void	print_sect_begin(void);
extern void	print_sect_end(void);

extern void	*conf_sect_he_mzone;
extern void	*conf_param_he_mzone;

extern int	init_conf_tbls(const char *, int,
		    ipa_conf_sect *, struct conf_sect_hash **,
		    ipa_conf_param *, struct conf_param_hash **);
extern void	deinit_conf_tbls(int,
		    ipa_conf_sect *, struct conf_sect_hash *,
		    ipa_conf_param *, struct conf_param_hash *);

extern const ipa_conf_sect *find_conf_sect(const ipa_conf_sect *,
		    const struct conf_sect_hash *, const char *);
extern const ipa_conf_param *find_conf_param(const ipa_conf_param *,
		    const struct conf_param_hash *, const char *);

extern int	build_conf_re(void);

extern void	*dl_lookup_sym(dl_handle, const char *);

extern int	validate_name(const char *);
extern int	conf_validate_name(const char *);

extern char	*get_mod_name(char *);

#endif /* !IPA_CONFCOMMON_H */
