/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Botond Botyanszki <boti@rocketmail.com>
 *
 */

#ifndef _XIM_SERVER_H_
#define _XIM_SERVER_H_

#include "xim-ic.h"
#include "../im-ja.h"

typedef struct _IMJAXimServer IMJAXimServer;

struct _IMJAXimServer {
	/* xim connect list */
	IMJAXimConnect *connect_list;
	
	XIMS xims;
	Display *display;
	Window window;
	long filter_mask;
	XIMTriggerKey *trigger_keys;

	/* Input Context list */
	IMJAContext **ic_table;
	gulong ic_table_size;
	IMJAContext *ic_freed;

	Bool dynamic_event_flow;

	/* FIXME: move this to conf*/
	unsigned long preedit_fg;
	unsigned long preedit_bg;

};

void im_ja_xim_server_ic_table_expand();
IMJAContext *im_ja_xim_server_get_ic(CARD16 icid);
IMJAXimConnect *im_ja_xim_server_get_connect_by_id(CARD16 connect_id);
void im_ja_xim_server_add_connect(IMJAXimConnect *connect);
void im_ja_xim_server_remove_connect(IMJAXimConnect *connect);
IMJAContext *im_ja_xim_server_ic_create(IMChangeICStruct *data);


#endif
