/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method 
 *
 * Copyright (C) 2003 Botond Botyanszki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * Based on handler.c from nabi by Choe Hwanjin
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdkx.h>

#include "IMdkit/IMdkit.h"
#include "IMdkit/Xi18n.h"

#include "../error.h"
#include "../im-ja.h"

#include "xim-ic.h"
#include "xim-server.h"

extern IMJAXimServer *im_ja_xim_server;

static const char *xim_protocol_name(int major_code) {
	switch (major_code) {
	case XIM_CONNECT:
		return "XIM_CONNECT";
	case XIM_CONNECT_REPLY:
		return "XIM_CONNECT_REPLY";
	case XIM_DISCONNECT:
		return "XIM_DISCONNECT";
	case XIM_DISCONNECT_REPLY:
		return "XIM_DISCONNECT_REPLY";
	case XIM_AUTH_REQUIRED:
		return "XIM_AUTH_REQUIRED";
	case XIM_AUTH_REPLY:
		return "XIM_AUTH_REPLY";
	case XIM_AUTH_NEXT:
		return "XIM_AUTH_NEXT";
	case XIM_AUTH_SETUP:
		return "XIM_AUTH_SETUP";
	case XIM_AUTH_NG:
		return "XIM_AUTH_NG";
	case XIM_ERROR:
		return "XIM_ERROR";
	case XIM_OPEN:
		return "XIM_OPEN";
	case XIM_OPEN_REPLY:
		return "XIM_OPEN_REPLY";
	case XIM_CLOSE:
		return "XIM_CLOSE";
	case XIM_CLOSE_REPLY:
		return "XIM_CLOSE_REPLY";
	case XIM_REGISTER_TRIGGERKEYS:
		return "XIM_REGISTER_TRIGGERKEYS";
	case XIM_TRIGGER_NOTIFY:
		return "XIM_TRIGGER_NOTIFY";
	case XIM_TRIGGER_NOTIFY_REPLY:
		return "XIM_TRIGGER_NOTIFY_REPLY";
	case XIM_SET_EVENT_MASK:
		return "XIM_SET_EVENT_MASK";
	case XIM_ENCODING_NEGOTIATION:
		return "XIM_ENCODING_NEGOTIATION";
	case XIM_ENCODING_NEGOTIATION_REPLY:
		return "XIM_ENCODING_NEGOTIATION_REPLY";
	case XIM_QUERY_EXTENSION:
		return "XIM_QUERY_EXTENSION";
	case XIM_QUERY_EXTENSION_REPLY:
		return "XIM_QUERY_EXTENSION_REPLY";
	case XIM_SET_IM_VALUES:
		return "XIM_SET_IM_VALUES";
	case XIM_SET_IM_VALUES_REPLY:
		return "XIM_SET_IM_VALUES_REPLY";
	case XIM_GET_IM_VALUES:
		return "XIM_GET_IM_VALUES";
	case XIM_GET_IM_VALUES_REPLY:
		return "XIM_GET_IM_VALUES_REPLY";
	case XIM_CREATE_IC:
		return "XIM_CREATE_IC";
	case XIM_CREATE_IC_REPLY:
		return "XIM_CREATE_IC_REPLY";
	case XIM_DESTROY_IC:
		return "XIM_DESTROY_IC";
	case XIM_DESTROY_IC_REPLY:
		return "XIM_DESTROY_IC_REPLY";
	case XIM_SET_IC_VALUES:
		return "XIM_SET_IC_VALUES";
	case XIM_SET_IC_VALUES_REPLY:
		return "XIM_SET_IC_VALUES_REPLY";
	case XIM_GET_IC_VALUES:
		return "XIM_GET_IC_VALUES";
	case XIM_GET_IC_VALUES_REPLY:
		return "XIM_GET_IC_VALUES_REPLY";
	case XIM_SET_IC_FOCUS:
		return "XIM_SET_IC_FOCUS";
	case XIM_UNSET_IC_FOCUS:
		return "XIM_UNSET_IC_FOCUS";
	case XIM_FORWARD_EVENT:
		return "XIM_FORWARD_EVENT";
	case XIM_SYNC:
		return "XIM_SYNC";
	case XIM_SYNC_REPLY:
		return "XIM_SYNC_REPLY";
	case XIM_COMMIT:
		return "XIM_COMMIT";
	case XIM_RESET_IC:
		return "XIM_RESET_IC";
	case XIM_RESET_IC_REPLY:
		return "XIM_RESET_IC_REPLY";
	case XIM_GEOMETRY:
		return "XIM_GEOMETRY";
	case XIM_STR_CONVERSION:
		return "XIM_STR_CONVERSION";
	case XIM_STR_CONVERSION_REPLY:
		return "XIM_STR_CONVERSION_REPLY";
	case XIM_PREEDIT_START:
		return "XIM_PREEDIT_START";
	case XIM_PREEDIT_START_REPLY:
		return "XIM_PREEDIT_START_REPLY";
	case XIM_PREEDIT_DRAW:
		return "XIM_PREEDIT_DRAW";
	case XIM_PREEDIT_CARET:
		return "XIM_PREEDIT_CARET";
	case XIM_PREEDIT_CARET_REPLY:
		return "XIM_PREEDIT_CARET_REPLY";
	case XIM_PREEDIT_DONE:
		return "XIM_PREEDIT_DONE";
	case XIM_STATUS_START:
		return "XIM_STATUS_START";
	case XIM_STATUS_DRAW:
		return "XIM_STATUS_DRAW";
	case XIM_STATUS_DONE:
		return "XIM_STATUS_DONE";
	default:
		break;
	}

	return "XIM_UNKNOWN";
}

static Bool im_ja_xim_handler_open(XIMS ims, IMProtocol *call_data) {
	IMJAXimConnect* connect;
	IMOpenStruct *data = (IMOpenStruct *)call_data;

	IM_JA_DEBUG("open connect_id = 0x%x\n", (int)data->connect_id);

	connect = im_ja_xim_connect_create(data->connect_id);
	im_ja_xim_server_add_connect(connect);

	return True;
}

static Bool im_ja_xim_handler_close(XIMS ims, IMProtocol *call_data) {
	IMCloseStruct *data = (IMCloseStruct *)call_data;
	IMJAXimConnect *connect;
	
	IM_JA_DEBUG("im_ja_xim_handler_close: ");

	connect = im_ja_xim_server_get_connect_by_id(data->connect_id);
	im_ja_xim_server_remove_connect(connect);
	im_ja_xim_connect_destroy(connect);

	IM_JA_DEBUG("closing connect_id 0x%x\n", (int)data->connect_id);
	return True;
}

static Bool im_ja_xim_handler_create_ic(XIMS ims, IMProtocol *call_data) {
	IMJAContext *ic;
	IMChangeICStruct *data = (IMChangeICStruct *)call_data;

	IM_JA_DEBUG("im_ja_xim_handler_create_ic \t 0x%x\n", (int)data->connect_id);
	
	ic = im_ja_xim_server_ic_create(data);
	im_ja_xim_connect_add_ic(ic->connect, ic);

	return True;
}

static Bool im_ja_xim_handler_destroy_ic(XIMS ims, IMProtocol *call_data) {
	IMJAContext *ic;

	IM_JA_DEBUG("im_ja_xim_handler_destroy_ic\n");
  ic = im_ja_xim_server_get_ic(call_data->changeic.icid);

	if (ic != NULL) {
		im_ja_xim_connect_remove_ic(ic->connect, ic);
		im_ja_context_destroy(ic);
	}

	return True;
}

static Bool im_ja_xim_handler_set_ic_values(XIMS ims, IMProtocol *call_data) {
	IMChangeICStruct *data = (IMChangeICStruct *)call_data;
	IMJAContext *ic;

	IM_JA_DEBUG("im_ja_xim_handler_set_ic_values\n");
	ic = im_ja_xim_server_get_ic(data->icid);
			 
	if (ic != NULL)  im_ja_xim_ic_set_values(ic, data);

	return True;
}

static Bool im_ja_xim_handler_get_ic_values(XIMS ims, IMProtocol *call_data) {
	IMChangeICStruct *data = (IMChangeICStruct *)call_data;
	IMJAContext *ic;

	IM_JA_DEBUG("im_ja_xim_handler_get_ic_values\n");

	ic = im_ja_xim_server_get_ic(data->icid);

	if (ic != NULL) im_ja_xim_ic_get_values(ic, data);
	return True;
}

static Bool im_ja_xim_handler_forward_event(XIMS ims, IMProtocol *call_data) {
	gchar buf[64];
	KeySym keysym;
	XKeyEvent *kevent;
	IMForwardEventStruct *data;
	GdkKeymap *keymap; 
	GdkEvent *event;
	GdkDisplay *display;
	IMJAContext *ic;

	IM_JA_DEBUG("im_ja_xim_handler_forward_event\n");

 	data = (IMForwardEventStruct *)call_data;

	ic = im_ja_xim_server_get_ic(data->icid);
	if (ic == NULL) return True;

	if (data->event.type != KeyPress) {
		IM_JA_DEBUG("Not a key press\n");
		return True;
	}

	kevent = (XKeyEvent*)&data->event;

	display = gdk_x11_lookup_xdisplay(im_ja_xim_server->display);

	keymap = gdk_keymap_get_for_display(display);
	event = gdk_event_new(GDK_KEY_PRESS);

	event->key.time = kevent->time;
  event->key.state = (guint) kevent->state;
  event->key.hardware_keycode = kevent->keycode;
	XLookupString(kevent, buf, 64, &keysym, NULL);
	event->key.keyval = keysym;

	if (im_ja_filter_keypress(ic, &event->key) == TRUE) return True;

 	IMForwardEvent(ims, (XPointer)data);
	return True;
}

static Bool im_ja_xim_handler_set_ic_focus(XIMS ims, IMProtocol *call_data) {
	IMJAContext *ic;

	IM_JA_DEBUG("im_ja_xim_handler_set_ic_focus\n");

	ic = im_ja_xim_server_get_ic(call_data->changefocus.icid);

	if (ic == NULL) return True;

	if (ic->connect != NULL) im_ja_xim_ic_preedit_start(ic); /* FIXME */
	im_ja_got_focus(ic);

	return True;
}

static Bool im_ja_xim_handler_unset_ic_focus(XIMS ims, IMProtocol *call_data) {
	IMJAContext *ic;

	IM_JA_DEBUG("im_ja_xim_handler_unset_ic_focus\n");

	ic = im_ja_xim_server_get_ic(call_data->changefocus.icid);
	if (ic == NULL) return True;
	im_ja_lost_focus(ic);

	return True;
}

static Bool im_ja_xim_handler_reset_ic(XIMS ims, IMProtocol *call_data) {
	IM_JA_DEBUG("FIXME: im_ja_xim_handler_reset_ic\n");
	
	return True;
}

static Bool im_ja_xim_handler_trigger_notify(XIMS ims, IMProtocol *call_data) {
	/*IMTriggerNotifyStruct *data = (IMTriggerNotifyStruct *)call_data;*/
 
	IM_JA_DEBUG("FIXME: im_ja_xim_handler_trigger_notify\n");
	return True;
}

static Bool im_ja_xim_handler_preedit_start_reply(XIMS ims, IMProtocol *call_data) {
	IM_JA_DEBUG("FIXME: im_ja_xim_handler_preedit_start_reply\n");
	return True;
}

static Bool im_ja_xim_handler_preedit_caret_reply(XIMS ims, IMProtocol *call_data) {
	IM_JA_DEBUG("FIXME: im_ja_xim_handler_preedit_caret_reply\n");
	return True;
}

Bool im_ja_xim_handler(XIMS ims, IMProtocol *call_data) {
    IM_JA_DEBUG("im_ja_xim_handler: %s\t 0x%x 0x%x\n",
								xim_protocol_name(call_data->major_code),
								call_data->any.connect_id,
								call_data->changeic.icid);

    switch (call_data->major_code) {
    case XIM_OPEN:
	    return im_ja_xim_handler_open(ims, call_data);
    case XIM_CLOSE:
	    return im_ja_xim_handler_close(ims, call_data);
    case XIM_CREATE_IC:
	    return im_ja_xim_handler_create_ic(ims, call_data);
    case XIM_DESTROY_IC:
	    return im_ja_xim_handler_destroy_ic(ims, call_data);
    case XIM_SET_IC_VALUES:
	    return im_ja_xim_handler_set_ic_values(ims, call_data);
    case XIM_GET_IC_VALUES:
	    return im_ja_xim_handler_get_ic_values(ims, call_data);
    case XIM_FORWARD_EVENT:
	    return im_ja_xim_handler_forward_event(ims, call_data);
    case XIM_SET_IC_FOCUS:
	    return im_ja_xim_handler_set_ic_focus(ims, call_data);
    case XIM_UNSET_IC_FOCUS:
	    return im_ja_xim_handler_unset_ic_focus(ims, call_data);
    case XIM_RESET_IC:
	    return im_ja_xim_handler_reset_ic(ims, call_data);
    case XIM_TRIGGER_NOTIFY:
	    return im_ja_xim_handler_trigger_notify(ims, call_data);
    case XIM_PREEDIT_START_REPLY:
	    return im_ja_xim_handler_preedit_start_reply(ims, call_data);
    case XIM_PREEDIT_CARET_REPLY:
	    return im_ja_xim_handler_preedit_caret_reply(ims, call_data);
    default:
	    IM_JA_DEBUG("Unknown IMDKit Protocol message type\n");
	    break;
    }
    return True;
}
