/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method Module for GTK-2.0
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Botond Botyanszki <boti@rocketmail.com>
 *          
 */

#include <config.h>

#include <gtk/gtk.h>
#include <gtk/gtkimmodule.h>

#include "im-ja-impl.h"
#include "im-ja.h"
#include "error.h"
#include "conf.h"
#include "nls.h"
#include "statuswin.h"
#include "preeditwin.h"
#include "candwin.h"
#include "actionmenu.h"

extern IMJAConfig cfg; 
GList *status_windows = NULL;
static void destroy_win(StatusWin *status_win, gboolean remove_signal);

void status_window_disable_focus_out(GtkWidget *widget, GdkEvent *event, IMJAContext* cn) {
	IM_JA_DEBUG("status_window_disable_focus_out() enter-notify callback\n");
	cn->status_win->can_hide = FALSE;
}

void status_window_debug(IMJAContext* cn) {
#ifdef IMJA_TARGET_GTK
	if (cn->status_win != NULL) {
		IM_JA_DEBUG(" HAS FOCUS1: %d\n", GTK_WIDGET_HAS_FOCUS(cn->status_win->window));
		IM_JA_DEBUG(" HAS FOCUS2: %d\n", gtk_widget_is_focus(cn->status_win->window));
	}
	IM_JA_DEBUG(" CLIENT HAS GRAB: %d\n", GTK_WIDGET_HAS_GRAB(cn->client_gtk));
	IM_JA_DEBUG(" CLIENT HAS FOCUS: %d\n", GTK_WIDGET_HAS_FOCUS(cn->client_gtk));
	IM_JA_DEBUG(" CLIENT CAN FOCUS: %d\n", GTK_WIDGET_CAN_FOCUS(cn->client_gtk));
	
	/*IM_JA_DEBUG(" CLIENT IS MODAL: %d\n", gtk_window_get_modal(cn->client_gtk));*/

	IM_JA_DEBUG(" TOPLEVEL HAS GRAB: %d\n", GTK_WIDGET_HAS_GRAB(cn->toplevel_gtk));
	IM_JA_DEBUG(" TOPLEVEL HAS FOCUS: %d\n", GTK_WIDGET_HAS_FOCUS(cn->toplevel_gtk));
	IM_JA_DEBUG(" TOPLEVEL CAN FOCUS: %d\n", GTK_WIDGET_CAN_FOCUS(cn->toplevel_gtk));
	IM_JA_DEBUG(" TOPLEVEL IS MODAL: %d\n", gtk_window_get_modal(GTK_WINDOW(cn->toplevel_gtk)));
#endif
}

static void statuswin_press_cb(GtkWidget *button, GdkEventButton *event, IMJAContext* cn) {
	IM_JA_DEBUG("statuswin_press_cb\n");
	if (event->button == 1) {
		im_ja_actionmenu_button_press_cb(button, event, &cn->status_win->menu, 
																		 IM_JA_STATUSWIN_MENU, cn);
	}
}

static void statuswin_enter_cb(GtkWidget *widget, GdkEvent *event, IMJAContext* cn) {
	IM_JA_DEBUG("statuswin_enter_cb\n");
	gtk_frame_set_shadow_type(GTK_FRAME(cn->status_win->border), GTK_SHADOW_IN);
	im_ja_grab_add(widget, event, cn);
}

static void statuswin_leave_cb(GtkWidget *widget, GdkEvent *event, IMJAContext* cn) {
	IM_JA_DEBUG("statuswin_leave_cb\n");
	gtk_frame_set_shadow_type(GTK_FRAME(cn->status_win->border), GTK_SHADOW_OUT);
	im_ja_grab_remove(widget, event, cn);
}

static void status_window_on_realize(IMJAContext *cn) {
		gtk_widget_realize(cn->status_win->eventbox);
		gdk_window_set_cursor(cn->status_win->eventbox->window, gdk_cursor_new(GDK_HAND2));
		status_window_update_location(cn);
}

void status_window_show(IMJAContext* cn) {

	IM_JA_DEBUG("status_window_show\n");

	if (cn->show_first == FALSE) return; /* don't show until we get focus once */
	if (candidate_window_is_shown(cn) == TRUE) return; /* don't show if the candidate window is shown */

	/*status_window_debug(cn);*/
#ifdef IMJA_TARGET_GTK
	if ((cn->toplevel_gtk != NULL) && GTK_WIDGET_HAS_GRAB(cn->toplevel_gtk) == TRUE) {
		IM_JA_DEBUG("GRABBED TOPLEVEL!\n");
	}

	/* FIXME: gtk bug */
	if (cn->client_gtk != NULL) {
		if (GTK_IS_ENTRY(cn->client_gtk) == TRUE) {
			if (gtk_editable_get_editable(GTK_EDITABLE(cn->client_gtk)) == FALSE) {
			IM_JA_DEBUG("non-editable GtkEntry.\n");
			return;
			}
		}
		if (GTK_IS_TEXT_VIEW(cn->client_gtk) == TRUE) {
			if (gtk_text_view_get_editable(GTK_TEXT_VIEW(cn->client_gtk)) == FALSE) {
				IM_JA_DEBUG("non-editable GtkTextView.\n");
				return;
			}
		}
	}
#endif

	if ((cn->preedit_win_on == TRUE) && (cn->input_method != IM_JA_DIRECT_INPUT)) {
		/* Show preedit window instead */
		preedit_window_show(cn);
		return;
	}

	if (cfg.status_win_position == STATUS_DISABLED) return;
	
	if (cn->candidate_win != NULL) {
			if (GTK_WIDGET_VISIBLE(cn->candidate_win->window) == TRUE)	return;
	}

	if ((cn->input_method == IM_JA_DIRECT_INPUT) || (cn->input_method == IM_JA_KANJIPAD_INPUT))	{
		return;
	}

	if (cn->status_win == NULL) {
		IM_JA_DEBUG("creating status win\n");
		cn->status_win = g_new0(StatusWin, 1);
		status_windows = g_list_append(status_windows, cn->status_win);
		/*
		//g_object_set_data(G_OBJECT(cn->toplevel_gdk), "im-ja-status-window", cn->status_win);
		//= g_object_get_data(G_OBJECT(cn->toplevel_gdk), "im-ja-status-window");
		*/

		cn->status_win->can_hide = TRUE;
		cn->status_win->menu = NULL;

		cn->status_win->window = gtk_window_new(GTK_WINDOW_POPUP);
		/*gtk_window_unstick(GTK_WINDOW(cn->status_win->window)); */
		/*cn->status_win->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);*/
		/*gtk_window_set_type_hint(GTK_WINDOW(cn->status_win->window), GDK_WINDOW_TYPE_HINT_MENU);*/

		gtk_window_set_title(GTK_WINDOW(cn->status_win->window), _("[status window]"));
		im_ja_join_modal_window(cn, cn->status_win->window);
		cn->status_win->eventbox = gtk_event_box_new();
		gtk_container_add(GTK_CONTAINER(cn->status_win->window), cn->status_win->eventbox);
		gtk_widget_show(cn->status_win->eventbox);
		/* If the preedit gets the focus, we should be still receiving keyboard input */
		g_signal_connect(G_OBJECT(cn->status_win->eventbox), "enter_notify_event",
										 G_CALLBACK(statuswin_enter_cb), cn);
		g_signal_connect(G_OBJECT(cn->status_win->eventbox), "leave_notify_event",
										 G_CALLBACK(statuswin_leave_cb), cn);
		g_signal_connect(G_OBJECT(cn->status_win->eventbox), "button_press_event",
										 G_CALLBACK(statuswin_press_cb), cn);

		cn->status_win->border = gtk_frame_new(NULL);
		gtk_frame_set_shadow_type(GTK_FRAME(cn->status_win->border), GTK_SHADOW_OUT);
		gtk_container_add(GTK_CONTAINER(cn->status_win->eventbox), cn->status_win->border);
		cn->status_win->label = gtk_label_new(cfg.status_win_labels[cn->input_method]);
		gtk_container_add(GTK_CONTAINER(cn->status_win->border), cn->status_win->label);
		gtk_misc_set_padding(GTK_MISC(cn->status_win->label), 2, 2);

		/* This hack is to disable flashy behaviour when status window gets the focus*/
		g_signal_connect(G_OBJECT(cn->status_win->window), "enter_notify_event", 
										 G_CALLBACK(status_window_disable_focus_out), cn);
		/*			
		cn->status_win->size_allocate_id = g_signal_connect_swapped(G_OBJECT(cn->toplevel_gtk), "size_allocate",
																																G_CALLBACK(status_window_update_location), cn);
		g_signal_connect_swapped(G_OBJECT(cn->toplevel_gtk), "destroy",
														 G_CALLBACK(toplevel_destroyed_cb), cn->status_win);
		//cn->status_win->toplevel_gtk = cn->toplevel_gtk;
		*/
		g_signal_connect_swapped(G_OBJECT(cn->status_win->window), "realize",
														 G_CALLBACK(status_window_on_realize), cn);
		
	}
	else {
		gtk_label_set_text(GTK_LABEL(cn->status_win->label), cfg.status_win_labels[cn->input_method]);
		status_window_update_location(cn);
	}
#ifdef IMJA_TARGET_XIM
	status_window_hide_all();
#endif

	gtk_widget_show_all(cn->status_win->window);

}

void status_window_force_hide(IMJAContext *cn) {
	
	IM_JA_DEBUG("status_window_force_hide\n");

	if (cn->status_win != NULL) {
		gtk_widget_hide_all(cn->status_win->window);
	}
}

void status_window_hide(IMJAContext *cn) {
	
	IM_JA_DEBUG("status_window_hide\n");
	/*status_window_debug(cn);*/	

	if (cn->status_win != NULL) {
		if (cn->status_win->menu != NULL) {
			/* don't hide if we have the menu pulled out */
			if ((GTK_WIDGET_HAS_GRAB(cn->status_win->menu) == TRUE)
					&& (cn->preedit_win_on != TRUE)) return;
		} 

		if (gtk_widget_is_focus(cn->status_win->window) == TRUE) return;
		if (gtk_window_has_toplevel_focus(GTK_WINDOW(cn->status_win->window)) == TRUE) return;
		if (gtk_window_is_active(GTK_WINDOW(cn->status_win->window)) == TRUE) return;
		if (cn->status_win->can_hide == TRUE) gtk_widget_hide_all(cn->status_win->window);
	}
}

static void destroy_win(StatusWin *status_win, gboolean remove_signal) {
	IM_JA_DEBUG("status_win: destroy_win() [%d]\n", (int) status_win);
	if (status_win == NULL) return;
	if (g_list_find(status_windows, status_win) == NULL) {
		IM_JA_DEBUG("*ERROR* status window is already destroyed\n");
		return;
	}
	status_windows = g_list_remove(status_windows, status_win);
	if (GTK_IS_WIDGET(status_win->window) == TRUE) gtk_widget_destroy(status_win->window);
	/* g_free(status_win); this causes a segfault in some cases */
}

void status_window_destroy(IMJAContext *cn) {
	IM_JA_DEBUG("status_window_destroy()\n");
	if (cn->status_win == NULL) return;
	destroy_win(cn->status_win, TRUE);
	cn->status_win = NULL;
}

void status_window_destroy_all() {
	IM_JA_DEBUG("status_window_destroy_all()\n");
	g_list_foreach(status_windows, (GFunc) destroy_win, (gpointer) TRUE);
	g_list_free(status_windows);
	status_windows = NULL;
}


void status_window_hide_all() {
	GList *windows = status_windows; 
	StatusWin *status_win;

	IM_JA_DEBUG("status_window_hide_all()\n");
	
	while (windows != NULL) {
		status_win = (StatusWin *) windows->data;
		if (status_win != NULL) {
			if (gtk_widget_is_focus(status_win->window) == TRUE) return;
			if (status_win->can_hide == TRUE) gtk_widget_hide_all(status_win->window);
		}
		windows = g_list_next(windows);
	}
}

void status_window_update_location(IMJAContext *cn) {
	gint status_w, status_h;
	GdkRectangle client_rect;
	GdkRectangle toplevel_rect;
	gint target_x = 0, target_y = 0;

	IM_JA_DEBUG("status_window_update_location [type: %d]\n", cfg.status_win_position);
	if (cn->status_win !=	NULL) {
		if (cfg.status_win_position == STATUS_DISABLED) return;
		/* IM_JA_DEBUG("offsets x: %d, y: %d\n", cn->cursor_pos_offset_x, cn->cursor_pos_offset_y); */

		if (cfg.status_win_position == STATUS_BELOW_CURSOR) {
			if ((cn->cursor_pos_offset_x == 0) && (cn->cursor_pos_offset_y == 0)) {
				/* no position is available */
				/*cn->candwin_style = CANDWIN_STYLE_TABLE;	*/
				goto status_win_bottom_left; /* GOTO is not very nice */
			}

			im_ja_get_client_window_geometry(cn, &client_rect);

			target_x = client_rect.x + cn->cursor_pos_offset_x;
			target_y = client_rect.y + cn->cursor_pos_offset_y;

			/* check if target_ is within the toplevel window */
			im_ja_get_toplevel_window_geometry(cn, &toplevel_rect);
			/* im_ja_move_within_toplevel(cn, &target_x, &target_y, &toplevel_rect); */
			im_ja_move_within_rect(cn, &target_x, &target_y, &client_rect);
			
			gtk_window_get_size(GTK_WINDOW(cn->status_win->window), &status_w, &status_h);
			/* IM_JA_DEBUG("[BELOW CURSOR] move status window to x: %d, y: %d\n", target_x - status_w/2, target_y); */
			gtk_window_move((GTK_WINDOW(cn->status_win->window)), target_x - status_w/2, target_y);
			/* IM_JA_DEBUG("VISIBLE: %d\n", GTK_WIDGET_VISIBLE(cn->status_win->window)); */
			return;
		}
		
		if (cfg.status_win_position == STATUS_WINDOW_BOTTOM_LEFT) {
		status_win_bottom_left:
			im_ja_attach_bottom_left(cn, cn->status_win->window);
			return;
		}
		
		if (cfg.status_win_position == STATUS_FIXED_COORD) {
			gtk_window_move((GTK_WINDOW(cn->status_win->window)), cfg.status_win_coords[0], cfg.status_win_coords[1]);
			return;
		}
	}
}
