/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method Module for GTK-2.0
 *
 * Copyright (C) 2004 Botond Botyanszki <boti@rocketmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _SKKCONV_H_
#define _SKKCONV_H_

#include "skklib.h"
#include "../im-ja.h"

enum {
  SKKCONV_UNCONVERTED,
  SKKCONV_CONVERTED
};

enum {
  SKKCONV_PREV,
  SKKCONV_NEXT
};

enum {
  SKKCONV_FORWARD,
  SKKCONV_BACKWARD
};

typedef struct _SKKContext SKKContext;
struct _SKKContext {
  gchar kana_buf[BUFFERSIZE];
  gint cursor_pos;
  gint conv_state;
  GList *clauselist;
  GList *curr_clause;
};

typedef struct _SKKClause SKKClause;
struct _SKKClause {
  gchar *kana_start;
  gchar *kana_end;
  CandList cand;
  CandList selected_cand;
  gint conv_state;
};


SKKClause *skkconv_convert_clause(gchar *conv_start, gchar *conv_end, gboolean shrink);
void skkconv_reset_ctx(SKKContext *skkctx);
void skkconv_roma2kana(SKKContext *skkctx, gint input_method);
void skkconv_insert_string(SKKContext *skkctx, gchar *strg);
void skkconv_convert_all(SKKContext *skkctx);
void skkconv_delete_char(SKKContext *skkctx, gint direction);
void skkconv_move_cursor(SKKContext *skkctx, gint direction);
void skkconv_free_clauselist(SKKContext *skkctx);
void skkconv_unconvert_all(SKKContext *skkctx);
void skkconv_unconvert_clause(SKKClause *clause);
void skkconv_unconvert_current_clause(SKKContext *skkctx);
void skkconv_select_clause(SKKContext *skkctx, gint direction);
void skkconv_fix_selected_candidate(SKKContext *skkctx, gint selected);
void skkconv_select_candidate(SKKContext *skkctx, gint direction);
void skkconv_resize_clause(SKKContext *skkctx, gint direction);

#endif
