/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method Module for GTK-2.0
 *
 * Copyright (C) 2004 Botond Botyanszki <boti@rocketmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Botond Botyanszki <boti@rocketmail.com>
 */

#ifndef _ROMAKANA_H_
#define _ROMAKANA_H_

typedef struct _romapair {
  gchar* roma;
  gchar* kana;
} romapair;

gboolean im_ja_kana_filter_keypress(IMJAContext *context, GdkEventKey *key);
gchar *roma2kana(gchar *romastr, gint input_method);
gchar *roma2kana_i(gchar *romastr, gint *index, gint input_method);
gchar *roma2kana_i_lastpass(gchar *romastr, gint *index, gint input_method);
gboolean im_ja_kana_convert_tailing_n(IMJAContext *cn);

#endif
