/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* radical.h, adopted from gjiten's kanjidic.h

   Copyright (C) 1999 - 2006 Botond Botyanszki <boti@rocketmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published  by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __RADICAL_H__
#define __RADICAL_H__

#include <gtk/gtk.h>
#include "im-ja.h"

#define RADKFILE_NAME IM_JA_DATADIR"/radkfile.utf8"

#define RADLISTLEN 19

typedef struct _RadInfo {
	gunichar radical;
	gint strokes;
	GList *kanji_info_list;
} RadInfo;

typedef struct _KanjiInfo {
	gunichar kanji;
	GList *rad_info_list;
} KanjiInfo;

typedef struct _RadTable {
	gchar *radkfile;
	GtkWidget *window;
	GtkWidget *kanji_results_view;
	GtkTextBuffer *kanji_results_buffer;
	GtkTextIter kanji_results_iter;
	GtkWidget *entry_radical;
	GHashTable *rad_button_hash;
	GHashTable *kanji_info_hash;
	GHashTable *rad_info_hash;
	GList *rad_info_list;
} RadTable;

void im_ja_radtable_show(IMJAContext *cn);

#endif
