/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method Module for GTK-2.0
 * Copyright (C) 2003 Botond Botyanszki <boti@rocketmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __PREEDIT_AREA_H__
#define __PREEDIT_AREA_H__


#include <gdk/gdk.h>
#include <gtk/gtkmisc.h>
#include <gtk/gtkwindow.h>



#define TYPE_PREEDIT_AREA              (preedit_area_get_type ())
#define PREEDIT_AREA(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREEDIT_AREA, PreeditArea))
#define PREEDIT_AREA_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREEDIT_AREA, PreeditAreaClass))
#define IS_PREEDIT_AREA(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREEDIT_AREA))
#define IS_PREEDIT_AREA_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREEDIT_AREA))
#define PREEDIT_AREA_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREEDIT_AREA, PreeditAreaClass))
       

typedef struct _PreeditArea       PreeditArea;
typedef struct _PreeditAreaClass  PreeditAreaClass;


struct _PreeditArea {
  GtkMisc misc;

  /*< private >*/
  gchar  *text; 
  PangoAttrList *attrs;
  PangoAttrList *effective_attrs;
  gint cursor_pos;
  PangoLayout *layout;
};

struct _PreeditAreaClass {
  GtkMiscClass parent_class;
};

GType preedit_area_get_type(void) G_GNUC_CONST;
GtkWidget *preedit_area_new(const char *str);
void preedit_area_set_text(PreeditArea *area, const char *str);
G_CONST_RETURN gchar *preedit_area_get_text(PreeditArea *area);
void preedit_area_set_attributes(PreeditArea *area, PangoAttrList *attrs);
PangoAttrList *preedit_area_get_attributes(PreeditArea *area);
PangoLayout *preedit_area_get_layout(PreeditArea *area);
void preedit_area_set_cursor_pos(PreeditArea *area, gint pos);

#endif /* __PREEDIT_AREA_H__ */
