/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/*
 * IM-JA Japanese Input Method Module for GTK-2.0
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Botond Botyanszki <boti@rocketmail.com>
 *
 */

#include <glib.h>

#define HELPER_MSG_PING "PING"
#define HELPER_MSG_ACK "ACK"
#define HELPER_MSG_OK "OK"
#define HELPER_MSG_FAILED "FAILED"
#define HELPER_MSG_SET_INPUT_METHOD "SET_INPUT_METHOD"
#define HELPER_MSG_QUERY_INPUT_METHOD "QUERY_INPUT_METHOD"
#define HELPER_MSG_CHANGE_STATUS "CHANGE_STATUS"
/*
#define HELPER_MSG_STATUS_CHANGED "STATUS_CHANGED"
*/

typedef struct _ClientIO ClientIO;
struct _ClientIO {
	gint sock;
	GIOChannel *io;
	guint watch_id;
};

ClientIO *helper_client_io_new_from_socket(gint sock);
ClientIO *helper_client_io_new_connection(gboolean usetray);
gboolean helper_client_io_send(ClientIO *client, gchar *string);
void helper_client_io_close(ClientIO *client);
gboolean helper_client_send_command(ClientIO *client, gchar *command, gint param);
