#!/usr/bin/perl

open(NEWHEAD, ">$ARGV[0]-convtable.h") || die "Can't open\n";
select(NEWHEAD);
#print "#ifndef _CONVTABLE_H\n";
#print "#define _CONVTABLE_H\n";
open(TABLE, "$ARGV[0]-convtable.txt") || die "Can't open\n";
print '#include "romakana.h"', "\n";
print "romapair $ARGV[0]table[] = {\n";

my %escapes;
for (0..255) {
    $escapes{chr($_)} = sprintf("\\x%02X", $_);
}

while(<TABLE>) {
  if( /^$/ ) {
    print "\n";
    next;
  }
  @pair = split(/\s/);
  print "  { \"" . getHex($pair[0]) . "\", \"" . getHex($pair[1]) . "\" },\n";
}
print "};\n";
close(TABLE);
#print "\n#endif /* _CONVTABLE_H */\n";
close(NEWHEAD);


sub getHex {
    my ($strg) = @_;
    my $result = '';
    foreach $chr (split('', $strg)) {
	$result .= $escapes{$chr};
    }
    return $result;
}
