/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */

#ifndef _CONF_H_
#define _CONF_H_

#include <gconf/gconf.h>
#include <glib.h>
#include "im-ja.h"

typedef struct _IMJAConfig IMJAConfig;

struct _IMJAConfig{
	guint hotkey_states[HOTKEYS_TOTAL];
	guint hotkey_values[HOTKEYS_TOTAL];

	GdkColor preedit_colors[4]; /* preedit string colors: n_fg, n_bg, hl_fg, hl_bg */
	gboolean custom_preedit_n;
	gboolean custom_preedit_hl;
	
	gint status_win_position;
	gchar *status_win_labels[IM_JA_INPUT_METHODS_TOTAL];
	gint status_win_coords[2];
  
	gint default_conv_engine;
	gchar *wnn_address;
	gchar *wnnenvrc;
  
	gboolean canna_enabled;

	gboolean kanjipad_enabled;
	gboolean kanjipad_custom_size;
	gint kanjipad_size[2];

	gboolean use_systray;
	gboolean preedit_window_on;
	gint startup_input_method;
	gchar *im_ja_version;
	gint candwin_style;
	gboolean custom_candwin_font;
	gchar *candwin_font;
	gboolean commit_on_reset;

	gchar *browser;	
	gboolean dont_show_save_warning;

	gint temp[200];
};

/* public function prototypes */
gboolean im_ja_init_conf_handler();
void im_ja_finalize_conf_handler(IMJAConfig *cfg);
gboolean im_ja_load_conf(IMJAConfig *cfg);
gboolean im_ja_save_conf(IMJAConfig *cfg);
gchar *get_string_from_color(GdkColor *color);
gboolean im_ja_get_gconf_client();
gchar *im_ja_get_keyname(guint state, guint keyval);

#endif
