#ifndef _COMMON_H_
#define _COMMON_H_

#include <gdk/gdkevents.h>
#include "conf.h"

#ifndef WCHAR_DEFINED
#define WCHAR_DEFINED
#undef wchar
typedef unsigned short wchar;
#endif


gchar *euc2utf8(const gchar *str);
gchar *utf82euc(const gchar *str);
gchar *utf8to16(const gchar *str);
int euc2wc(gchar *eucstr);
gchar *wc2euc(wchar *wcstr, gint size);
gchar *hira2kata(gchar *hirastr);
gchar *full2half(gchar *instr);
gboolean isKanaChar(gunichar c);
gboolean isKatakanaChar(gunichar c);
gboolean isHiraganaChar(gunichar c);
gboolean isKanjiChar(gunichar c);
gboolean isJPChar(gunichar c);
gboolean isOtherChar(gunichar c);
gboolean ishotkey(GdkEventKey *key, int hotkey, IMJAConfig *cfg);
gboolean im_ja_is_printable_key(GdkEventKey *key);
gboolean buffer_delchar(gchar* buf);
/* gchar *get_utf8_for_keyval(guint keyval);
gint char_to_byte_pos(gchar *str, gint pos);
*/

/* these return the number of bytes added or removed */
int buffer_inschar(char* buf,int maxbuf,char *ins,int pos);
int buffer_bkspchar(char* buf,int pos);
int buffer_deltchar(char* buf,int pos);


#endif
