/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method Module for GTK-2.0
 *
 * Copyright (C) 2003 Botond Botyanszki <boti@rocketmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */



#ifndef _ACTIONMENU_H_
#define _ACTIONMENU_H_


typedef struct _ActionMenuProperty ActionMenuProperty;

/* ActionMenu types */
typedef enum {
  IM_JA_PANEL_MENU        = 1 << 0,
  IM_JA_STATUSWIN_MENU    = 1 << 1,
  IM_JA_GTKIM_MENU        = 1 << 2
} ImJaActionMenuType;

struct _ActionMenuProperty {
  gint id; /* action id number */ 
  gchar *name; /* name that will be shown on the menu */
  gchar *description; /* longer description of the action */
  gchar *label; /* label that will be shown on the button, retrieved from the gconf settings */ 
  gchar *hotkey_name; /* the hotkey that can trigger the action, retrieved from the gconf settings */ 
  ImJaActionMenuType menu_type;
  gint input_method; /* -1 for action, e.g. start im-ja-conf */
};


void im_ja_actionmenu_populate(gpointer data, GtkMenu *menu, ImJaActionMenuType menu_type);
gint im_ja_action_to_input_method(gint action_id);
void im_ja_actionmenu_button_press_cb(GtkWidget *widget, GdkEventButton *event, GtkWidget **menu, 
				      ImJaActionMenuType type, gpointer data);
#endif
