#!/bin/bash

NAME=im-ja
VER=`cat ../configure.in |grep "IM_JA_VERSION=" |sed s/IM_JA_VERSION=//` 
CVSLABEL=""
REL=1
ARCH=`uname -i`


if ! RPM_BASE=`mktemp -d /tmp/temp.MakeRpm.sh.XXXXXX`
then
    echo "failed to create tempdir"
    exit -1
fi

echo "using RPM_BASE=$RPM_BASE";
echo

MKDIRLIST="$RPM_BASE/BUILD $RPM_BASE/RPMS $RPM_BASE/SOURCES $RPM_BASE/SPECS $RPM_BASE/SRPMS"

for dirn in $MKDIRLIST
do
	mkdir -p $dirn
done

PKG_VER="$NAME-$VER"

TARBALL="$RPM_BASE/SOURCES/$PKG_VER.tar.gz"

mkdir "$RPM_BASE/SOURCES/$PKG_VER"
( 
	echo "Copying files to $RPM_BASE/SOURCES/$PKG_VER"
	echo "cp -R ../* $RPM_BASE/SOURCES/$PKG_VER"
	cp -R ../* "$RPM_BASE/SOURCES/$PKG_VER"
	cd "$RPM_BASE/SOURCES/"
	echo
	echo "Creating tarball $TARBALL"
	echo "tar -czvf $TARBALL $PKG_VER"
	tar -czvf $TARBALL $PKG_VER
	echo
	echo "ls -l $RPM_BASE/SOURCES/"
	ls -l $RPM_BASE/SOURCES/
)


SPEC_FILE="$NAME.spec"
RPM_SPEC="$RPM_BASE/SPECS/$SPEC_FILE"
BINARY_RPM="$RPM_BASE/RPMS/$ARCH/$PKG_VER-$REL.$ARCH.rpm"

cp $SPEC_FILE $RPM_SPEC

(
	echo cd "$RPM_BASE/SPECS/"
	cd "$RPM_BASE/SPECS/"
	ls -ld "$RPM_BASE/SPECS/"
	echo "Building Binary RPM"
	echo rpmbuild -bb $RPM_OPTS $SPEC_FILE
	rpmbuild -bb --define="_topdir $RPM_BASE" --target $ARCH $SPEC_FILE
)

#SOURCE_RPM= $(RPM_BASE)/SRPMS/$(PKG_VER)-$(REL).src.rpm
#	(cd $(RPM_BASE)/SPECS; \
#	rpmbuild -bs $(RPM_OPTS) $(SPEC_FILE))


echo ls -ld $RPM_BASE/SOURCES/
ls -ld $RPM_BASE/SOURCES/
ls -ld $RPM_BASE/RPMS/

echo "getting rpm"
mv $BINARY_RPM . || cp $RPM_BASE/RPMS/$ARCH/*.rpm .

echo
echo "Cleaning up tempfiles"
echo "rm -r $RPM_BASE"
rm -r $RPM_BASE



