/* main.h
 * - Main Function Headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __ICECAST_MAIN_H
#define __ICECAST_MAIN_H

void *threaded_server_proc(void *infoarg);
void client_login(connection_t *con, char *line);
void setup_defaults();
void setup_signal_traps();
void allocate_resources();
void startup_mode();
void clean_shutdown(server_info_t *info);
void usage();
void setup_listeners();
void initialize_network ();
#ifdef _WIN32
BOOL WINAPI win_sig_die (DWORD CtrlType);
#else /* _WIN32 */
RETSIGTYPE sig_hup(int signo);
RETSIGTYPE sig_die(int signo);
RETSIGTYPE sig_die_hard (int signo);
RETSIGTYPE sig_child(int signo);
#endif
char *splitc(char *first, char *rest, const char divider);
void close_socket(sock_t sock);

#endif
