/* Copyright 1991 by John Atwood deVries II. */
/* $Id: s_who.c,v 1.27 2001/10/30 05:09:04 jwise Exp $ */
/* For copying and distribution information, see the file COPYING. */

/* primitive to list users */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include "externs.h"

#define DOGROUPONLY	1
#define DOSHORT		2

void	s_who (int, int);
static void	doAll (int, int);
static void	doOne (int, int, char *);
static void	print_group_header (int, int);
static void	print_group_members (int, int, int);
static void	pgm_long (int, int);
static void	pgm_short (int, int);

void
s_who(int n, int argc)
{
	int len;
	int flags;
	int target_user;
	char tgrp[MAX_GROUPLEN + 1];
	char * cp;

	if (argc == 2) {
		/* fields[0] was "w" */
		/* fields[1] is a string indicating the kind of who */

		/* handle the flags (if any) */
		cp = getword(fields[1]);
		if (strcasecmp(cp, "-g") == 0) {
			flags = DOGROUPONLY;
		} else if (strcasecmp(cp, "-s") == 0){
			flags = DOSHORT;
		} else if (strcasecmp(cp, "?") ==0){
			sends_cmdout(n, "Usage: /w {-g | -s} {groupname}");
			return;
		} else {
			flags = 0;
		}

		/*
		   use fields[1] if no flag
		   otherwise use get_tail(fields[1])
		*/
		if (flags == 0) {
			len = strlen(getword(fields[1]));
		} else {
			len = strlen(getword(get_tail(fields[1])));
		}

		if (flags == 0) {
			strlcpy(tgrp, getword(fields[1]), MAX_GROUPLEN + 1);
		} else {
			strlcpy(tgrp, getword(get_tail(fields[1])), MAX_GROUPLEN + 1);
		}

		if (len == 0) {
			/* of all groups */
			debug("all groups");
			doAll(n, flags);
		} else {
			/* on some particular group */
			if (fields[1][0] == '@') 
			{
				if ((target_user = find_user(&fields[1][1])) < 0) {
					senderror(n, "User not found.");
					return;
					}
				else
				{
					if ((g_tab[find_group(u_tab[target_user].group)].visibility == SUPERSECRET) &&
							(strncmp("ADMIN", u_tab[n].nickname, MAX_NICKLEN))) {
						senderror(n, "User not found.");
						return;
					}
					else
						strlcpy(tgrp, u_tab[target_user].group, MAX_GROUPLEN + 1);
				}
			}

			if (strcmp(tgrp, ".")==0) {
				/* n's group */
				strlcpy(tgrp, u_tab[n].group, MAX_GROUPLEN + 1);
				debug("substitute n's group");
			}
			debug("one particular group");
			doOne(n, flags, tgrp);
		}
	} else {
			error("who: wrong number of arguments");
	}
}

static void
doAll(int n, int flags)
{
	int group;
	int my_group;
	int is_invited;
	int num_users = 0;
	int num_groups = 0;
	int group_list[MAX_GROUPS];
	int i, j, groups = 0;
	char line[LINE_SIZE];

	my_group = find_group(u_tab[n].group);

	snprintf(line, LINE_SIZE, "%s@%s", u_tab[n].loginid, u_tab[n].nodeid);
	ucaseit(line);
	for (group=0; group < MAX_GROUPS; group++) {
                is_invited = (nlpresent(u_tab[n].nickname, 
			   *g_tab[group].n_invites) || 
			((nlpresent(u_tab[n].nickname, 
			   *g_tab[group].nr_invites)) && 
			   (strlen(u_tab[n].realname) > 0)) ||
			(nlmatch(line, *g_tab[group].s_invites)) ||
			((nlmatch(line, *g_tab[group].s_invites)) &&
			   (strlen(u_tab[n].realname) > 0)) ||
                        (! strncmp("ADMIN", u_tab[n].nickname, MAX_NICKLEN)));
                if( (strlen(g_tab[group].name)!=0) &&
                    ((g_tab[group].visibility != SUPERSECRET) || is_invited ||
                        (group == my_group))) {
		    if (groups == 0)
		       group_list[0] = group;
		    else {
		       i = 0;
		       while ((i < groups) && (strcasecmp(g_tab[group].name,
		                 g_tab[group_list[i]].name) > 0))
			   i++;
		       for (j = (groups + 1); j > i; j--)
			   group_list[j] = group_list[j - 1];
		       group_list[i] = group;
		       }
		    groups++;
		}
	}
	for (i = 0; i < groups; i++)
            doOne(n, flags, g_tab[group_list[i]].name);

        for (i = 0; i < MAX_REAL_USERS; i++)
		if (u_tab[i].login == 1)
			num_users++;
	for (i = 0; i < MAX_GROUPS; i++)
		if (strlen(g_tab[i].name) > 0)
			if ((strcmp(g_tab[i].name, "ICB") != 0) || (count_users_in_group("ICB") > 1))
				num_groups++;
	if (num_users == 0)
		snprintf(line, LINE_SIZE, "No users found.");
	else if (num_users > 1) {
		if (num_groups > 1)
			snprintf(line, LINE_SIZE, "Total: %d users in %d groups", num_users, num_groups);
		else
			snprintf (line, LINE_SIZE, "Total: %d users in %d group", num_users, num_groups);
	} else if (num_groups > 1)
	      snprintf (line, LINE_SIZE, "Total: %d user in %d groups", num_users, num_groups);
	else
	      snprintf (line, LINE_SIZE, "Total: %d user in %d group", num_users, num_groups);

	sends_cmdout(n, line);
}

static void
doOne(int n, int flags, char *tgrp)
{
	int	which;
	char	line[LINE_SIZE];

	which = find_group(tgrp);

	if (which >= 0) {
		/* the group exists */
		/* how says whether to print the header or not */
		print_group_header(n, which);
		print_group_members(n, which, flags);
	} else {
		/* the group doesn't exist */
		snprintf(line, LINE_SIZE, "The group %s doesn't exist.", tgrp);
		senderror(n, line);
	}
}

static void
print_group_header(int n, int grp)
{
	char GroupName[MAX_GROUPLEN + 3];
	char TheMod[MAX_NICKLEN + 7];
	int mod;
	char TheTopic[MAX_TOPICLEN + 1];
	char Options[20];
	int isMyGroup;
	int is_invited;
	static char *ctl[] = {"*", "p", "m", "r", "c"};
	static char *vol[] = {"*", "q", "n", "l"};
	static char *vis[] = {"*", "v", "s", "i"};
	long TheTime;
	char line[LINE_SIZE];

	snprintf(line, LINE_SIZE, "%s@%s", u_tab[n].loginid, u_tab[n].nodeid);
	ucaseit(line);
	mod = g_tab[grp].mod;
	if (mod < 0)
		if (g_tab[grp].modtimeout == 0.0)
			strlcpy(TheMod, "(None)", MAX_NICKLEN + 7);
		else {
			TheTime = time(NULL);
			snprintf(TheMod, MAX_NICKLEN + 7, "%s (%d)", g_tab[grp].missingmod, 
				(int) (g_tab[grp].modtimeout - TheTime));
		}
	else
		strlcpy(TheMod, u_tab[mod].nickname, MAX_NICKLEN + 7);

	if (strlen(g_tab[grp].topic) == 0) {
		strlcpy(TheTopic, "(None)", MAX_TOPICLEN + 1);
	} else {
		strlcpy(TheTopic, g_tab[grp].topic, MAX_TOPICLEN + 1);
	}

	snprintf(Options, 10, "(%s%s%s)", ctl[g_tab[grp].control], vis[g_tab[grp].visibility], vol[g_tab[grp].volume]);

	isMyGroup = (find_group(u_tab[n].group) == grp);
        is_invited = (nlpresent(u_tab[n].nickname, 
			   *g_tab[grp].n_invites) || 
			((nlpresent(u_tab[n].nickname, 
			   *g_tab[grp].nr_invites)) && 
			   (strlen(u_tab[n].realname) > 0)) ||
			(nlmatch(line, *g_tab[grp].s_invites)) ||
			((nlmatch(line, *g_tab[grp].s_invites)) &&
			   (strlen(u_tab[n].realname) > 0)) ||
                        (! strncmp("ADMIN", u_tab[n].nickname, MAX_NICKLEN)));
        if ((g_tab[grp].visibility == SECRET) ||
            (g_tab[grp].visibility == SUPERSECRET))
                if (!isMyGroup && !is_invited)
                        strlcpy(GroupName,"-SECRET-", MAX_GROUPLEN + 3);
                else {
                        strlcpy(GroupName, "*", MAX_GROUPLEN + 3);
                        strlcat(GroupName, g_tab[grp].name, MAX_GROUPLEN + 3);
                        strlcat(GroupName, "*", MAX_GROUPLEN + 3);
		}
        else {
                strlcpy(GroupName,g_tab[grp].name, MAX_GROUPLEN + 3);
        }

	sends_cmdout(n, " "); /* a blank line */
	snprintf(line, LINE_SIZE, "Group: %-8s %s Mod: %-13s Topic: %s",
			GroupName, Options, TheMod, TheTopic);
	sends_cmdout(n, line);

}

static void
print_group_members(int n, int which, int flags)
{
	if (flags & DOGROUPONLY) {
		/* don't print users */
	} else {
		if(flags & DOSHORT) {
			pgm_short(n, which);
		} else {
			pgm_long(n, which);
		}
	}
}

static void
pgm_long(int n, int which)
{
        int user;
	int Idle;
	long TheTime;
	int gpmod;
	int num_users;
	char cp[5];
	char * reg;
	int user_list[MAX_REAL_USERS];
	int i, j;
	int users = 0;


	TheTime = time(NULL);

	num_users = count_users_in_group(g_tab[which].name);
	if (num_users >= 2)      /* bweh! */
		user_whead(n);
        for(user=0; user<MAX_USERS; user++) {
                /* are they in this group? */
                if(which == find_group(u_tab[user].group)) {
			if (users == 0) 
			   user_list[0] = user;
			else {
		        i = 0;
#ifdef SORT_BY_NICKNAME
		        while ((i < users) && (strcasecmp(u_tab[user].nickname,
		                 u_tab[user_list[i]].nickname) > 0))
#else
		        while ((i < users) && u_tab[user].t_group >
		                 u_tab[user_list[i]].t_group)
#endif
			   i++;
		        for (j = (users + 1); j > i; j--)
			   user_list[j] = user_list[j - 1];
		        user_list[i] = user;
			}
                        users++;
		        }
		}
		for (i = 0; i < users; i++)
			{
			user = user_list[i];
			Idle = TheTime - u_tab[user].t_recv;

			gpmod = (g_tab[which].mod == user);
			if (gpmod) {
				strlcpy(cp, "m", 5);
			} else {
				strlcpy(cp, " ", 5);
			}

			if (strlen(u_tab[user].realname) == 0) {
				reg = "(nr)";
			} else {
				reg = " ";
			}

			user_wline(n, cp, u_tab[user].nickname, Idle, 0,
                                            u_tab[user].t_on,
                                            u_tab[user].loginid,
                                            u_tab[user].nodeid,
                                            reg);
                }
}

static void
pgm_short(int n, int which)
{
	int user;
	int num_users;
	char row[ROW_SIZE];

	num_users = count_users_in_group(g_tab[which].name);
	row[0] = '\0';

	add_item(n, "    Members: ", row);

	for(user=0; user<MAX_USERS; user++) {
		/* are they in this group? */
		if(which == find_group(u_tab[user].group)) {
			add_item(n, u_tab[user].nickname, row);
			num_users--;
			if (num_users != 0) {
				add_item(n, ", ", row);
			}
		}
	}
	/* flush last line if any */
	if (strlen(row) != 0) {
		sends_cmdout(n, row);
	}
}
