/* Copyright (c) 1991 by John Atwood deVries II. */
/* $Id: msgs.c,v 1.35.4.1 2006/04/30 23:28:07 jwise Exp $ */

/* handle various messages from the client */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <fnmatch.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "externs.h"
#include "lookup.h"

void	openmsg (int, char *);
int	loginmsg (int, char *);
void	cmdmsg (int, char *);
void	pong (int, char *);

/* open message */
/*
   note that we need to know who sent the message.  it doesn't
   come with the sender's nick, so we have to reformat the message
   before sending it to the group
*/

int u_recv_count[MAX_USERS];

void
openmsg(int n, char *pkt)
{
	long TheTime;
	int gi;
	char line[LINE_SIZE];

        if (u_tab[n].login == 1) {
        	TheTime = time(NULL);

		if ( !strcmp (u_tab[n].group, "1") )
		{
		    u_recv_count[n]++;
		    if ( u_tab[n].t_recv == TheTime )
		    {
			if ( u_recv_count[n] > 2 )
			{
			    /* tell 'em it happened. */
			    sendstatus(n, "Boot", "No spamming in group 1.");
			    snprintf(line, LINE_SIZE, "%s was auto-booted for spamming.", u_tab[n].nickname);
			    s_status_group(1,1,n, "Boot", line);
			    /* fake an s_change to group ICB */
			    strcpy (fields[1], "ICB");
			    is_booting = 1;
			    s_change(n, 2);
			    is_booting = 0;
			}
		    }
		    else
		    {
			u_recv_count[n] = 0;
		    }
		}

	        /* record the time */
                u_tab[n].t_recv= TheTime;

		if (split(pkt) != 1) {
			error("got bad open message packet");
		} else {
#ifdef VERBOSE
		   snprintf(line, LINE_SIZE,"[OPEN] %d", n);
		   MDB(line);
#endif
		   gi = find_group(u_tab[n].group);
		   if (g_tab[gi].volume == QUIET)
			senderror(n,
			"Open messages not permitted in quiet groups.");
		    /*
		     * if the group is CONTROLLED,  and they
		     * aren't the moderator, check to make sure they are in
		     * in the talk list
		     */
		    else if ( (g_tab[gi].control == CONTROLLED
			&& g_tab[gi].mod != n)
		        && ( (nlpresent (u_tab[n].nickname,
			    *g_tab[gi].n_talk) == 0)
			&& (strlen (u_tab[n].realname) <= 0
			    || nlpresent (u_tab[n].nickname,
				*g_tab[gi].nr_talk) == 0) ) )
		    {
			senderror (n, "You do not have permission to send open messages in this group.");
			snprintf (line, LINE_SIZE, "Use \"/m %s may i talk?\" to request permission.",
			    		u_tab[g_tab[gi].mod].nickname);
			sendstatus (n, "INFO", line);
		    }
		   else if (count_users_in_group(g_tab[gi].name) < 2)
			senderror(n, "No one else in group!");
		   else {
			s_send_group(n);
		   }
		}
	} else {
		error("cannot send open messages until logged in");
	}
}


/*
   they sent us a login message. we need to put their info into 
   the user information table and then send them back a loginok message.
   for any field they didn't specify, come up with a plausible default.
   we also need to handle "w" vs. "login"
   we also need to dump them if they try using a:
	nickname already in use -or-
	group they aren't allowed to enter.
   their loginid may NOT be blank or null
*/

int
loginmsg(int n, char *pkt)
{
	/* n is socket on which they sent message */
	/* pkt is packet buffer */
	int num_fields;
	char *password = "";
	char which_group[MAX_NICKLEN+4];
	char one[LINE_SIZE], two[LINE_SIZE], three[LINE_SIZE];
	int len;
	int ret;
	int i, j;
	long TheTime;
	int target_user;
	char * cp;
	int access_file;
	char c;
	char line[LINE_SIZE];

	if (u_tab[n].login == 1) {
		senderror(n, "Already logged in.");
		return 1;
		}

	u_tab[n].login = 0;
	/* just in case */
	TheTime = time(NULL);

	num_fields = split(pkt);

	if (num_fields < 4)
		return -1;
	else if (num_fields > 4)
		password = fields[4];

	len = strlen(fields[2]);

	if (len == 0) { /* no group specified, give them one */
		strlcpy(which_group,"1", MAX_NICKLEN+4);
	} else {
		strlcpy(which_group, fields[2], MAX_NICKLEN+4);
	}

	if ( strcasecmp(fields[3],"w") == 0) {
		/* who only */
		fields[0][0] = 'w';
		fields[0][1] = '\000';
		fields[1][0] = '\000';
		s_who(n, 2);
		return -1; /* fail */
	}
	else
	{
	    /* regular login */

	    /* make sure the nickname hasn't already been taken */
	    if (find_user(fields[1]) >= 0) {
		    /* oops, someone already has this nick */
		    senderror(n,"Nickname already in use.");
		    return(-1);
	    }

	    /* make sure it isn't a null nickname */
	    if ((strlen(fields[1]) <= 0) || (strlen(fields[1]) > MAX_NICKLEN)) {
		    snprintf(line, LINE_SIZE, "Nickname must be between 1 and %d characters.", MAX_NICKLEN);
		    senderror(n, line);
		    return -1;
	    }

	    /* make sure the length of the loginid isn't wrong */
	    if ((strlen(fields[0]) <= 0) || (strlen(fields[0]) > MAX_IDLEN)) {
		    snprintf(line, LINE_SIZE, "Login id must be between 1 and %d characters.", MAX_IDLEN);
		    senderror(n, line);
		    return -1;
	    }
	    for (i = 0; i < strlen(fields[0]); i++)
		    if (isalnum((int)fields[0][i]) == 0) {
			    senderror(n, "Login id must contain only alphanumeric characters.");
			    return -1;
		    }

	    /* This is set up in s_new_user now */
	    cp = u_tab[n].nodeid;

	    three[0] = '\0';
	    snprintf(one, LINE_SIZE, "%s@%s", fields[0], cp);
	    ucaseit(one);
	    access_file = open(ACCESS_FILE, O_RDONLY);
	    if (access_file >= 0) {
	       while ((i = read(access_file, &c, 1)) > 0) {
		    if (isspace((int)c)) {
			    ucaseit(three);
			    if (!fnmatch(three, one, 0)) {
			       snprintf(line, LINE_SIZE, "Login refused for %s", one);
			       senderror(n, line);
			       MDB(line);
			       two[0] = '\0';
			       while ((i = read(access_file, &c, 1)) > 0) {
				  int l;
				  if (c == '\012') break;
				  l = strlen(two);
				  two[l] = c;
				  two[l+1] = '\0';
				  }
			       snprintf(line, LINE_SIZE, "Reason: %s", two);
			       senderror(n, line);
			       snprintf (line, LINE_SIZE, "Email %s for details.", SERVER_ADMIN);
			       senderror(n, line);
			       if (close(access_file) != 0) {
				    error("Access File Close: %s", strerror(errno));
				    }
			       return -1;
			    }
			    three[0] = '\0';
		    }
		    else {
			    int l;

			    l = strlen(three);
			    three[l] = c;
			    three[l+1] = '\0';
		    }
	       }
	       if (close(access_file) != 0) {
			    error("Access File Close: %s", strerror(errno));
			    }
	       }
	    else {
	       error("Access File Open: %s", strerror(errno));
	       }
		    
    /* get rid of nasty characters in the nickname */
    	    debug("filtering nickname");
	    filternickname(fields[1]);
	    

	    /* fill in what we can */
    	    debug("filling in user entry");
	    fill_user_entry(n, fields[0], cp, fields[1],
		password, "", 0, 0, 0);

	    snprintf(line, LINE_SIZE, "[LOGIN] %d: %s@%s", n, fields[0], cp);
	    MDB(line);

	    /* make sure they are allowed to use this nickname */
	    if (strcasecmp(fields[1],"admin") == 0) {
		if (!check_auth(n)){
			/* oops, password is wrong */
			senderror(n,"Nickname already in use.");
			return(-1);
		}
	    }

	    send_loginok(n);

	    s_motd(n,2);

	    if (which_group[0] == '@')
	    {
		if ((target_user = find_user(&which_group[1])) < 0)
		{
		    senderror (n,
			"User not found or is in a secret or invisible group.");
		    return(-1);
		}
		else
		{
		    int	g = find_group(u_tab[target_user].group);

		    if ( ((g_tab[g].visibility == SUPERSECRET)
			|| (g_tab[g].visibility == SECRET))
			&& (strncmp("ADMIN", u_tab[n].nickname, MAX_NICKLEN)))
		    {
			senderror (n,
			    "User not found or is in a secret or invisible group.");
			return (-1);
		    }
		    else
			strlcpy (which_group, u_tab[target_user].group, MAX_NICKLEN+4);
		}
	    }

	    /* fake a s_change */
	    strcpy(fields[1],which_group);
	    debug(fields[1]);
	    if (s_change(n,2) < 0) {
		    /* login fails because can't get into that group */
		    return(-1);
	    }

	    /* could find group slot, all is ok */
	    /* fill in last members of table entry */
	    u_tab[n].login = 1;
	    u_tab[n].t_on = TheTime;
	    u_tab[n].t_recv = TheTime;
	    u_tab[n].t_sent = TheTime;
	    u_tab[n].pri_n_hushed = (NAMLIST *) malloc(sizeof(NAMLIST));
	    nlinit(u_tab[n].pri_n_hushed, MAX_HUSHED);
	    u_tab[n].pub_n_hushed = (NAMLIST *) malloc(sizeof(NAMLIST));
	    nlinit(u_tab[n].pub_n_hushed, MAX_HUSHED);
	    u_tab[n].pri_s_hushed = (NAMLIST *) malloc(sizeof(NAMLIST));
	    nlinit(u_tab[n].pri_s_hushed, MAX_HUSHED);
	    u_tab[n].pub_s_hushed = (NAMLIST *) malloc(sizeof(NAMLIST));
	    nlinit(u_tab[n].pub_s_hushed, MAX_HUSHED);
	    u_tab[n].n_notifies = (NAMLIST *) malloc(sizeof(NAMLIST));
	    nlinit(u_tab[n].n_notifies, MAX_NOTIFIES);
	    u_tab[n].s_notifies = (NAMLIST *) malloc(sizeof(NAMLIST));
	    nlinit(u_tab[n].s_notifies, MAX_NOTIFIES);

	    snprintf(line, LINE_SIZE, "Welcome to ICB %s", u_tab[n].nickname);
	    sends_cmdout(n, line);

	    snprintf(one, LINE_SIZE, "%s@%s", u_tab[n].loginid, u_tab[n].nodeid);
	    ucaseit(one);
	    strlcpy(three, u_tab[n].nickname, LINE_SIZE);
	    ucaseit(three);
	    for (j = 0; j < MAX_USERS; j++)
		    if ((n != j) && (u_tab[j].login > 0)) {
			    if ((nlmatch(three, *u_tab[j].n_notifies) ||
			       nlmatch(one, *u_tab[j].s_notifies)) && 
			       (g_tab[find_group(u_tab[n].group)].visibility !=
				  SUPERSECRET)) {
				    snprintf (two, LINE_SIZE, "%s (%s) has just signed on", u_tab[n].nickname, one);
				    sendstatus(j, "Notify-On", two);
			    }
		    }

	    /* check to see if we know this person */
    	    debug("About to do nicklookup");
	    ret = nicklookup(n, u_tab[n].nickname);
	    if (ret == 0) {
		    /* we know this person */
		    strlcpy(u_tab[n].realname, "registered",MAX_NICKLEN+1);
		    sends_cmdout(n, "Nick registered");
		    nickwritetime(n, 0);
		    for (i = 1; i < MAX_GROUPS; i++)
			    if ((g_tab[i].modtimeout > 0.0) && (strcmp(g_tab[i].missingmod, u_tab[n].nickname)==0)){
			      g_tab[i].modtimeout = 0;
			      g_tab[i].mod = n;
			      g_tab[i].missingmod[0] = '\0';
			      snprintf(line, LINE_SIZE, "%s is the active moderator again.", u_tab[n].nickname);
			      for (j = 1; j <= MAX_REAL_USERS; j++)
				    if ((strcasecmp(u_tab[j].group, g_tab[i].name) == 0) && (j != n))
					sendstatus(j, "Mod", line);
			      snprintf(line, LINE_SIZE, "You are the moderator of group %s", g_tab[i].name);
			      sendstatus(n, "Mod", line);
			    }
		    if ((i = nickckmsg(n)) > 0)
		    {
			    if (i == 1)
				    sendstatus(n, "Message", "You have 1 message");
			    else {
				    snprintf(line, LINE_SIZE, "You have %d messages", i);
				    sendstatus(n, "Message", line);
				    }
		    }
	    }
#if 0 /* XXX nbftp has this */
	    else if (ret == -2 && strlen(password) > 0)
	    {
		    /*
		     * if they have given a password in the login msg,
		     * try to auth with that
		     */
		    nickwrite(n, password);
	    }
#endif
	    else if (ret == -2) /* we know this person but they're not validated */
	    {
	    sendstatus(n, "Register", "Send password to authenticate your nickname.");
	    j = 0;
	    for (i = 0; i < MAX_GROUPS; i++)
		if (strcasecmp(u_tab[n].nickname, g_tab[i].missingmod) == 0) {
		    snprintf(line, LINE_SIZE, "You are moderator of group %s", g_tab[i].name);
		    sendstatus(n, "Mod", line);
		    j++;
		}
	    if (j == 1) sendstatus(n, "Mod", "You must register using /p <password> to regain mod of the above group.");
	    if (j > 1) sendstatus(n, "Mod", "You must register using /p <password> to regain mod of the above groups.");
	    }
	    else {
		    sendstatus(n, "No-Pass", "Your nickname does not have a password.");
		    sendstatus(n, "No-Pass", "For help type /m server ?");
	    }

	    snprintf(one, LINE_SIZE, "%s@%s", u_tab[n].loginid, u_tab[n].nodeid);
	    ucaseit(one);
	    for (i = 0; i < MAX_GROUPS; i++)
	    {
		if ((nlpresent(u_tab[n].nickname, *g_tab[i].n_invites) > 0) ||
		   		(nlmatch(one, *g_tab[i].s_invites)) ||
		   		(nlpresent(u_tab[n].nickname, *g_tab[i].nr_invites) &&
		      		(strlen(u_tab[n].realname) > 0)) ||
		   		(nlmatch(one, *g_tab[i].sr_invites) && 
		      		(strlen(u_tab[n].realname) > 0))) {
		   snprintf(line, LINE_SIZE, "Invited to: %s", g_tab[i].name);
		   sends_cmdout(n, line);
		   }
		
		talk_report (n, i);
	    }

	    return 0;
	}
}

/* command message */

void
cmdmsg(int n, char *pkt)
{
	int argc;
	long TheTime;
	char line[LINE_SIZE];

        if (u_tab[n].login == 1) {

                /* record the time */
                TheTime = time(NULL);
                u_tab[n].t_recv= TheTime;

		argc = split(pkt);

#ifdef VERBOSE
		if (strcmp(fields[0], "m") == 0)
			snprintf(line, LINE_SIZE, "[COMMAND] %d: %s %s", n, fields[0], getword(fields[1]));
		else
			snprintf(line, LINE_SIZE, "[COMMAND] %d: %s %s", n, fields[0], fields[1]);
		MDB(line);
#endif
	
		switch(lookup(fields[0], command_table)) {

			case CMD_DROP:
				s_drop(n, argc);
				break;

			case CMD_RESTART:
				s_restart(n, argc);
				break;
			
			case CMD_SHUTDOWN:
				s_shutdown(n, argc);
				break;

			case CMD_WALL:
				s_wall(n, argc);
				break;

		 	case CMD_BEEP:
				s_beep(n, argc);
				break;

			case CMD_CANCEL:
				s_cancel(n, argc);
				break;

			case CMD_G:	
				s_change(n, argc);
				break;

			case CMD_INVITE:
				s_invite(n, argc);
				break;

			case CMD_PASS:
				s_pass(n, argc);
				break;

			case CMD_BOOT:
				s_boot(n, argc);
				break;

			case CMD_STATUS:
				s_status(n, argc);
				break;

			case CMD_TOPIC:
				s_topic(n, argc);
				break;

			case CMD_MOTD:
				s_motd(n, argc);
				break;

			case CMD_M:
				s_personal(n, argc);
				break;

			case CMD_ECHOBACK:
				s_echoback(n, argc);
				break;

			case CMD_NAME:
				s_name(n, argc);
				break;

			case CMD_V:
				s_version(n, argc);
				break;

			case CMD_W:
				s_who(n, argc);
				break;

			case CMD_INFO:
				s_info(n, argc);
				break;

			case CMD_NEWS:
				s_news(n, argc);
				break;

			case CMD_HUSH:
			case CMD_SHUSH:
				s_hush(n, argc);
				break;

			case CMD_HELP:
				s_help(n, argc);
				break;

			case CMD_EXCLUDE:
				s_exclude(n, argc);
				break;

			case CMD_SHUTTIME:
				s_shuttime(n, argc);
				break;

			case CMD_NOTIFY:
				s_notify(n, argc);
				break;

			case CMD_BRICK:
				s_brick(n, argc);
				break;

			case CMD_PING:
				sendping(n);
				break;

			case CMD_TALK:
				s_talk(n, argc);
				break;

			case CMD_NOBEEP:
				s_nobeep(n, argc);
				break;

		default:
			if (lookup(fields[0], auto_table) >= 0)
				autoCommand(n, 0);
			else {
				sendstatus(n, "Server", "Unknown command");
				info("%d: Invalid command \"%s\"", n, fields[0]);
				}
		}
	} else {
		error("cannot issue command until logged in");
	}
}


/* pong message */

/*ARGSUSED*/
void
pong(int n, char *pkt)
{
        if (u_tab[n].login == 1) {
		info("%d: pong message", n);
	} else {
		error("cannot send pong message until signed on");
	}
}
