/* Copyright (c) 1991 by John Atwood deVries II. */
/* $Id$ */
/* For copying and distribution information, see the file COPYING */

#include <sys/types.h>
#include <sys/time.h>
#include "config.h"
#include "ipcf.h"
#include "groups.h"
#include "server.h"

extern int icbd_log;
extern int is_booting;

#define MDB(x)	mdb(x)
#ifdef DEBUG
#define debug(x) debugx(x)
#else
#define debug(x)
#endif

/* defined in split.c */
extern char *fields[MAX_FIELDS];	/* split fields */

/* defined in globals.c */
extern char *pp;		/* packet pointer */
extern char *thishost;		/* our hostname */
extern USER_ITEM u_tab[MAX_USERS];	/* user table */
extern GROUP_ITEM g_tab[MAX_GROUPS];	/* group table */
/* number of bricks left */
extern int S_bricks[MAX_REAL_USERS];

/* lookup tables */
/* commands */
extern char *command_table[];
/* status options */
extern char *status_table[];
/* automagic resident user commands */
extern char *auto_table[];

/* if there is a connection to kill, else 0 */
extern int S_kill[MAX_REAL_USERS];

extern long TimeToDie;
extern int ShutdownNotify;
extern int restart;

/* from libmurgil.a (now merged with icb server sources) */
extern fd_set fdset;			/* player fd set for select() */
extern fd_set serversocks;
extern int highestfd;
extern struct timeval *polltimeout;	/* timeout value in msec for select() */
extern struct itimerval *polldelay;	/* timeout value in msec for select() */
extern struct Cbuf cbufs[MAX_USERS+1];/* user packet buffers */

/* from access.c */
int     setsecure (int, int);
int     valuser (const char *, const char *);
void    nickdelete (int, const char *);
void    nickwritemsg (int, const char *, char *);
int     nickckmsg (int);
void    nickreadmsg (int);
void    nickwritetime (int, int);
void    nickchinfo (int, const char *, char *, int, const char *);
void    nickchpass (int, const char *, char *);
void    nickwrite (int, const char *);
int     nicklookup (int, const char *);

/* from auto.c */
void    autoCommand (int, int);

/* from discuser.c */
void	disconnectuser (int);

/* from dispatch.c */
void    dispatch(int, char *);

/* from errors.c */
void    mdb (char *);
void	debugx (char *, ...);
void	error (const char *, ...);
void	info (char *, ...);

/* from getrname.c */
char	*getremotename (int);

/* from groups.c */
void    clear_group_item (int);
void    init_groups (void);
int     find_group (char *);
int     find_empty_group (void);
int     check_mods(int);
void    fill_group_entry(int, char *, char *, int, int, int, int);

/* from ipcf.c */
void	s_didpoll (int);
void	s_lost_user (int);
void	s_packet (int, char *);

/* from lookup.c */
int     lookup (char *, char *[]);

/* from main.c */
void    close_logs (void);
void    cycle_logs (int);
void    icbexit (int);

/* from makeport.c */
int	makenewport (char *, int);

/* from msgs.c */
void    openmsg (int, char *);
int     loginmsg (int, char *);
void    cmdmsg (int, char *);
void    pong (int, char *);

/* from namelist.c */
void    nlput (NAMLIST *, char *);
char    *nlget (NAMLIST *);
int     nlcount (NAMLIST);
void    nlclear (NAMLIST *);
void    nlinit (NAMLIST *, int);
int     nldelete (NAMLIST *, char *);
int     nlpresent (char *, NAMLIST);
int     nlmatch (char *, NAMLIST);

/* from newconnect.c */
int	newconnect (int);

/* from readpacket.c */
int	readpacket (int, struct Cbuf *);

/* from s_admin.c */
void    s_drop (int, int);
void    s_shutdown (int, int);
void    s_restart (int, int);
void    s_wall (int, int);
int     check_auth (int);

/* from s_beep.c */
void    s_beep (int, int);

/* from s_group.c */
void    s_cancel (int, int);
int     s_change (int, int);
void    s_invite (int, int);
void    s_pass (int, int);
void    s_boot (int, int);
void    s_status (int, int);
void    s_topic (int, int);
void    s_send_group (int);
void    s_exclude (int, int);
void    s_status_group (int, int, int, char *, char *);
void    s_talk (int, int);
void    talk_report (int, int);

/* from s_info.c */
void    s_info (int, int);

/* from s_motd.c */
void    s_motd (int, int);

/* from s_news.c */
void    s_news (int, int);

/* from s_person.c */
void    s_personal (int, int);

/* from s_shuttime.c */
void    s_shuttime (int, int);

/* from s_user.c */
void    s_help (int, int);
int     s_hush (int, int);
void    s_name (int, int);
int     s_notify (int, int);
void    s_echoback (int, int);
void   s_brick(int, int);
void    s_nobeep (int, int);

/* from s_version.c */
void    s_version (int, int);

/* from s_who.c */
void    s_who (int, int);
void    add_item (int, char *, char *);

/* from send.c */
void    sendopen (int, int, char *);
void    sendexit (int);
void    sendping (int);
void    senderror (int, char *);
void    sendstatus (int, char *, char *);
void    sends_cmdout (int, char *);
void    sendperson (int, int, char *);
void	sendsavedmessage(char *, int, char *);
void    sendbeep (int, int);
void    s_new_user (int);
void    send_loginok (int);
void    sendimport (int, char *, char *);
void    user_wline (int, char *, char *, int, int, int, char *, char *, char *);
void    user_whead (int);

/* from sendpacket.c */
int	sendpacket(int, char *);

/* from serverserve.c */
void	serverserve (void);

/* from setdelay.c */
void	setpolltimeout (int);
void	setpolldelay (int);

/* from signals.c */
void    trapsignals (void);
void    icbdump (int);
void    icbload (int);

/* from strings.c */
void    filternickname (char *);
void    filtertext (char *);
void    filtergroupname (char *);
void    lcaseit (char *);
void    ucaseit (char *);
char    *getword (char *);
char    *get_tail (char *);
int     split (char *);

/* from strlist.c */
void    strlinkhead (STRLIST *, STRLIST **, STRLIST **);
void    strunlink (STRLIST *, STRLIST **, STRLIST **);
STRLIST *strgetnode (char *, STRLIST *, int, int);

/* from unix.c */
void    clearargs (int, char **);

/* from users.c */
void    clear_user_item (int);
void    fill_user_entry (int, char *, char *, char *, char *, char *, int, int, int);
void    clear_users (void);
int     count_users_in_group (char *);
int     find_user (const char *);
