#! /bin/sh
#
#	Copyright (c) 2001 by Jim Wise
#	For copying and distribution information, see the file COPYING.
#
# PROVIDE: icbd
# REQUIRE: DAEMON

name="icbd"
command="@PREFIX@/sbin/icbd"
pidfile="/var/run/icbd.pid"

cmd=${1:-start}

case ${cmd} in
start)
	if [ -x ${command} ]; then
		echo "Starting ${name}."
		${command}
	fi
	;;
stop)
	if [ -x ${command} -a -f ${pidfile} ]; then
		echo "Stopping ${name}."
		kill `cat $pidfile`
	fi
	;;
restart)
	( $0 stop )
	sleep 5
	$0 start
	;;
*)
	echo "usage: $0 start|stop|restart"
esac
exit 0
