/* Copyright (c) 1990 by Carrick Sean Casey. */
/* For copying and distribution information, see the file COPYING. */

/* handle a packet from the server */

#include "icb.h"
#include "externs.h"

void	dispatch (char *pkt);

void
dispatch (char *pkt)
{
	switch(*pkt) {

	case ICB_PING:
		sendpong();
		break;

	case ICB_BEEP:
		beep(++pkt);
		break;

	case ICB_PROTO:
		protomsg(++pkt);
		break;

	case ICB_LOGINOK:
		loginokmsg(++pkt);
		break;

	case ICB_OPEN:
		copenmsg(++pkt);
		break;

	case ICB_STATUS:
		statusmsg(++pkt);
		break;

	case ICB_ERROR:
		errormsg(++pkt);
		break;

	case ICB_IMPORTANT:
		importantmsg(++pkt);
		break;

	case ICB_EXIT:
		exitmsg();
		break;

	case ICB_CMDOUT:
		cmdoutmsg(++pkt);
		break;

	case ICB_PERSONAL:
		cpersonalmsg(++pkt);
		break;

	default:
		sprintf(mbuf, "[=Error=] Invalid packet type \"%c\"", *pkt);
		putl(mbuf, PL_ALL);
	}
}
