//go:build !cgo

package gozstd

import (
	"github.com/klauspost/compress/zstd"
)

func Compress(dst, src []byte) []byte {
	w, _ := zstd.NewWriter(nil)
	defer w.Close()
	return w.EncodeAll(src, dst)
}

func Decompress(dst, src []byte) ([]byte, error) {
	r, _ := zstd.NewReader(nil)
	defer r.Close()
	return r.DecodeAll(src, dst)
}
